% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{get.meta}
\alias{get.meta}
\title{Get meta information of BioInstaller collected sources, such as database, 
GitHub source, non-GitHub source, web source}
\usage{
get.meta(value = NULL, config = NULL, get.meta.files.params = NULL,
  read.config.params = NULL)
}
\arguments{
\item{value}{Avaliable option for `db`, `github`, `nongithub`: `cfg_meta`, `item`; 
for web: `item`}

\item{config}{Avaliable option: `db`, `db_meta_file`, `github`, `github_meta_file`,
`nongithub`, `nongithub_meta_file`, `web`, `web_meta_file`}

\item{get.meta.files.params}{Params pass to \code{\link{get.meta.files}}}

\item{read.config.params}{Params pass to \code{\link[configr]{read.config}}}
}
\value{
List contain the meta files path of BioInstaller collected sources
}
\description{
Get meta information of BioInstaller collected sources, such as database, 
GitHub source, non-GitHub source, web source
}
\examples{
meta <- get.meta()
db_cfg_meta <- get.meta(config = 'db', value = 'cfg_meta')
db_meta_file <- get.meta(config = 'db_meta_file')
db_cfg_meta_parsed <- get.meta(value = 'cfg_meta', config = 'db', 
read.config.params = list(rcmd.parse = TRUE))
}
