% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARFitFun.R
\name{BigVAR.fit}
\alias{BigVAR.fit}
\title{Simple function to fit BigVAR model with fixed penalty parameter}
\usage{
BigVAR.fit(Y, p, struct, lambda, alpha = NULL, VARX = list(),
  separate_lambdas = F, MN = F, C = as.double(NULL),
  intercept = TRUE, tf = F, tol = 1e-04, RVAR = F, beta = NULL)
}
\arguments{
\item{Y}{\eqn{T \times k} multivariate time series or Y \eqn{T \times (k+m)} endogenous and exogenous series, respectively}

\item{p}{Predetermined maximal lag order (for modeled series)}

\item{struct}{The choice of penalty structure (see details).}

\item{lambda}{vector or matrix of penalty parameters.}

\item{alpha}{grid of candidate parameters for the alpha in the Sparse Lag and Sparse Own/Other VARX-L}

\item{VARX}{List containing VARX model specifications.}

\item{separate_lambdas}{indicator for separate penalty parameters for each time series (default \code{FALSE})}

\item{MN}{Minnesota Prior Indicator}

\item{C}{vector of coefficients to shrink toward a random walk (if \code{MN} is \code{TRUE})}

\item{intercept}{True or False: option to fit an intercept}

\item{tf}{transfer function indicator (i.e. VARX in which p=0 & s>0) (default false)}

\item{tol}{optimization tolerance (default 1e-4)}

\item{RVAR}{True or False: option to refit based upon the support selected using the Relaxed-VAR procedure}

\item{beta}{optional \eqn{k\times (k\times p + m\times s +1)} coefficient matrix to use as a "warm start" (default \code{FALSE})

 @details The choices for "struct" are as follows
\itemize{
\item{  "Basic" (Basic VARX-L)}
\item{  "Lag" (Lag Group VARX-L)} 
\item{  "SparseLag" (Lag Sparse Group VARX-L)} 
\item{  "OwnOther" (Own/Other Group VARX-L) }
\item{  "SparseOO" (Own/Other Sparse Group VARX-L) }
\item{  "EFX" (Endogenous First VARX-L)}
\item{  "HVARC" (Componentwise HVAR) }
\item{  "HVAROO" (Own/Other HVAR) }
\item{  "HVARELEM" (Elementwise HVAR)}
\item{  "Tapered" (Lag weighted Lasso VAR)}
\item{  "BGR" (Bayesian Ridge Regression (cf. Banbura et al))}
}

VARX specifications consist of a list with entry k denoting the series that are to be modeled and entry s to denote the maximal lag order for exogenous series.

The argument alpha is ignored unless the structure choice is "SparseLag" or "Lag."  By default "alpha" is set to \code{NULL} and will be initialized as 1/(k+1) in \code{cv.BigVAR} and \code{BigVAR.est}.  Any user supplied values must be between 0 and 1.}
}
\description{
Simple function to fit BigVAR model with fixed penalty parameter
}
\note{
The specifications "Basic", "Lag," "SparseLag," "SparseOO," and "OwnOther" can accommodate both VAR and VARX models.  EFX only applies to VARX models.  "HVARC," "HVAROO," "HVARELEM," and "Tapered" can only be used with VAR models.
}
\examples{
# VARX Example
# Fit a Basic VARX-L with k=2, m=1, s=2, p=4, lambda=1e-2
VARX=list()
VARX$k=2 # indicates that the first two series are modeled
VARX$s=2 # sets 2 as the maximal lag order for exogenous series
data(Y)
BigVAR.fit(Y,p=4,"Basic",lambda=1e-2,VARX=VARX)
}
\references{
William B Nicholson, Jacob Bien, and David S Matteson. "High Dimensional Forecasting via Interpretable Vector Autoregression." arXiv preprint arXiv:1412.5250, 2016.
William B. Nicholson, David S. Matteson, Jacob Bien,VARX-L: Structured regularization for large vector autoregressions with exogenous variables, International Journal of Forecasting, Volume 33, Issue 3, 2017, Pages 627-651,
William B Nicholson, David S. Matteson, and Jacob Bien (2016), "BigVAR: Tools for Modeling Sparse High-Dimensional Multivariate Time Series" arxiv:1702.07094

Banbura, Marta, Domenico Giannone, and Lucrezia Reichlin. "Large Bayesian vector auto regressions." Journal of Applied Econometrics 25.1 (2010): 71-92.
}
\seealso{
\code{\link{cv.BigVAR}},\code{\link{BigVAR.est}},\code{\link{constructModel}}
}
