% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bergm.R
\docType{methods}
\name{plot.bergm}
\alias{plot.bergm}
\title{Plot BERGM posterior output}
\usage{
\method{plot}{bergm}(x, ...)
}
\arguments{
\item{x}{an \code{R} object of class \code{bergm}.}

\item{...}{additional arguments, to be passed to lower-level functions.}
}
\description{
This function creates  MCMC diagnostic plots for \code{bergm} objects.
}
\examples{
\dontrun{
# Load the florentine marriage network
data(florentine)

# Posterior parameter estimation:
p.flo <- bergm(flomarriage ~ edges + kstar(2),
               burn.in    = 50,
               aux.iters  = 500,
               main.iters = 1000,
               gamma      = 1.2)

# MCMC diagnostics plots:
plot(p.flo)
}

}
