% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missBergm.R
\name{missBergm}
\alias{missBergm}
\title{Parameter estimation for Bayesian ERGMs under missing data}
\usage{
missBergm(formula, burn.in = 100, main.iters = 1000,
  aux.iters = 1000, prior.mean = NULL, prior.sigma = NULL,
  nchains = NULL, gamma = 0.5, sigma.epsilon = NULL, seed = NULL,
  startVals = NULL, nImp = NULL, missingUpdate = NULL, ...)
}
\arguments{
\item{formula}{formula; an \code{\link[ergm]{ergm}} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link[network]{network}} object
and <model terms> are \code{ergm-terms}.}

\item{burn.in}{count; number of burn-in iterations at the beginning of an MCMC run.
If \code{nchains} > 2,
it refers to the number of burn-in iterations for every chain of the population.}

\item{main.iters}{count; number of iterations for the MCMC chain(s) excluding burn-in.
If \code{nchains} > 2,
it refers to the number of iterations for every chain of the population.}

\item{aux.iters}{count; number of auxiliary iterations used for network simulation.}

\item{prior.mean}{vector; mean vector of the multivariate Normal prior.
By default set to a vector of 0's.}

\item{prior.sigma}{square matrix; variance/covariance matrix for the multivariate Normal prior.
By default set to a diagonal matrix with every diagonal entry equal to 100.}

\item{nchains}{count; number of chains of the population MCMC.
By default set to twice the model dimension (number of model terms).
If the model is one-dimensional, \code{nchains} = 1.}

\item{gamma}{scalar; ``parallel ADS move factor''.
If the model is one-dimensional, \code{nchains} = 1 and
\code{gamma} = \code{sigma.espilon}
and is used as the variance of the Normal proposal distribution.}

\item{sigma.epsilon}{square matrix;
variance/covariance matrix for the multivariate Normal proposal when \code{nchains} > 2.
By default set to a diagonal matrix with every diagonal entry equal to 0.0025.
If the model is one-dimensional, \code{sigma.espilon} = \code{gamma}
and is used as the variance of the Normal proposal distribution.}

\item{seed}{count;
random number seed for the Bergm estimation.}

\item{startVals}{numeric matrix;
Starting values for the parameter estimation. startVals requires a matrix with parameters by number of chains. If nchains == NULL, nchains is equal to 2 * the number of parameters in the model.}

\item{nImp}{count;
number of imputed networks to be returned. If null, no imputed network will be returned.}

\item{missingUpdate}{count;
number of tie updates in each imputation step. By default equal to number of missing ties. Smaller numbers increase speed. Larger numbers lead to better sampling.}

\item{...}{additional arguments, to be passed to lower-level functions.}
}
\description{
Function to fit Bayesian exponential random graphs models under missing data
using the approximate exchange algorithm.
}
\examples{
\dontrun{
# Load the florentine marriage network
data(florentine)


# Create missing data
set.seed(22101992)

missNode <- sample(1:16,1)
flomarriage[missNode,] <- NA
flomarriage[,missNode] <- NA


# Posterior parameter estimation:
m.flo <- missBergm(flomarriage ~ edges + kstar(2),
               burn.in = 50,
               aux.iters = 500,
               main.iters = 500,
               gamma = 1,
               nImp = 5)

# Posterior summaries:

bergm.output(m.flo)

# Bayesian goodness-of-fit test:

bgof(m.flo,
     aux.iters = 500,
     sample.size = 50,
     n.deg = 10,
     n.dist = 9,
     n.esp = 6)
}
}
\references{
Caimo, A. and Friel, N. (2011), "Bayesian Inference for Exponential Random Graph Models,"
Social Networks, 33(1), 41-55. \url{http://arxiv.org/abs/1007.5192}

Caimo, A. and Friel, N. (2014), "Bergm: Bayesian Exponential Random Graphs in R,"
Journal of Statistical Software, 61(2), 1-25. \url{jstatsoft.org/v61/i02}

Koskinen, J.H., Robins, G.L., Pattison, P.E. (2010), "Analysing exponential
random graph (p-star) models with missing data using bayesian data augmentation,"
Statistical Methodology 7(3), 366-384

Krause, R.W., Huisman, M., Steglich, C., Snijders, T.A. (2018), "Missing network
data a comparison of different imputation methods," Proceedings of the 2018
IEEE/ACM International Conference on Advances in Social Networks Analysis and
Mining 2018
}
