/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.tree.treemetrics.TreeMetric;
import dr.evomodel.tree.TreeStatistic;

public class TreeMetricStatistic
extends TreeStatistic {
    private Tree targetTree;
    private final Tree referenceTree;
    private final String focalNewick;
    private final TreeMetric treeMetric;

    public TreeMetricStatistic(String string, Tree tree, Tree tree2) {
        this(string, tree, tree2, null);
    }

    public TreeMetricStatistic(String string, Tree tree, Tree tree2, TreeMetric treeMetric) {
        super(string);
        this.referenceTree = tree;
        this.targetTree = tree2;
        this.treeMetric = treeMetric;
        this.focalNewick = TreeUtils.uniqueNewick(tree, tree.getRoot());
    }

    @Override
    public void setTree(Tree tree) {
        this.targetTree = tree;
    }

    @Override
    public Tree getTree() {
        return this.targetTree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        if (this.treeMetric == null) {
            return this.compareTreesByTopology();
        }
        return this.treeMetric.getMetric(this.referenceTree, this.targetTree);
    }

    private double compareTreesByTopology() {
        String string = TreeUtils.uniqueNewick(this.targetTree, this.targetTree.getRoot());
        return string.equals(this.focalNewick) ? 1.0 : 0.0;
    }
}

