/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.ComplexSubstitutionModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.ArrayList;

public class SVSComplexSubstitutionModel
extends ComplexSubstitutionModel
implements Likelihood,
BayesianStochasticSearchVariableSelection {
    private boolean isUsed = false;
    private double[] probability = null;
    private final Parameter indicatorsParameter;

    public SVSComplexSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, Parameter parameter, Parameter parameter2) {
        super(string, dataType, frequencyModel, parameter);
        if (parameter2 == null) {
            this.indicatorsParameter = new Parameter.Default(parameter.getDimension(), 1.0);
        } else {
            this.indicatorsParameter = parameter2;
            this.addVariable(parameter2);
        }
        this.setupIndicatorDimensionNames(-1);
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.ratesParameter.getParameterValue(i) * this.indicatorsParameter.getParameterValue(i);
        }
    }

    protected void setupIndicatorDimensionNames(int n) {
        int n2;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.indicatorsParameter.getParameterName();
        for (n3 = 0; n3 < this.dataType.getStateCount(); ++n3) {
            for (n2 = n3 + 1; n2 < this.dataType.getStateCount(); ++n2) {
                arrayList.add(this.getDimensionString(n3, n2, string));
            }
        }
        for (n3 = 0; n3 < this.dataType.getStateCount(); ++n3) {
            for (n2 = n3 + 1; n2 < this.dataType.getStateCount(); ++n2) {
                arrayList.add(this.getDimensionString(n2, n3, string));
            }
        }
        String[] stringArray = new String[]{};
        this.indicatorsParameter.setDimensionNames(arrayList.toArray(stringArray));
    }

    @Override
    public Parameter getIndicators() {
        return this.indicatorsParameter;
    }

    @Override
    public boolean validState() {
        return !this.updateMatrix || BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.probability, this);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (n > -1) {
            if (variable == this.ratesParameter && this.indicatorsParameter.getParameterValue(n) == 0.0) {
                return;
            }
            super.handleVariableChangedEvent(variable, n, changeType);
        } else {
            super.handleVariableChangedEvent(variable, n, changeType);
        }
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public void makeDirty() {
        this.updateMatrix = true;
    }

    @Override
    public boolean isUsed() {
        return super.isUsed() && this.isUsed;
    }

    @Override
    public void setUsed() {
        this.isUsed = true;
    }

    public Parameter getRatesParameter() {
        return this.ratesParameter;
    }
}

