/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.clock;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class UniversalClock
extends AbstractBranchRateModel {
    public static final String UNIVERSAL_CLOCK = "universalClock";
    Parameter rateParameter = null;
    Parameter massParameter = null;
    Parameter temperatureParameter = null;
    Parameter scaleParameter = null;

    public UniversalClock(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
        super(UNIVERSAL_CLOCK);
        this.rateParameter = parameter;
        this.massParameter = parameter2;
        this.temperatureParameter = parameter3;
        this.scaleParameter = parameter4;
        this.addVariable(parameter2);
        this.addVariable(parameter3);
        this.addVariable(parameter4);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.massParameter || variable == this.temperatureParameter) {
            if (n == -1) {
                this.calculateAllRates();
            } else {
                this.calculateRate(n);
            }
        } else if (variable == this.scaleParameter) {
            this.calculateAllRates();
        } else {
            throw new RuntimeException("unknown parameter changed in universalClock");
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    private void calculateAllRates() {
        int n = this.massParameter.getDimension();
        for (int i = 0; i < n; ++i) {
            this.calculateRate(i);
        }
    }

    private void calculateRate(int n) {
        double d = this.massParameter.getParameterValue(n);
        double d2 = this.temperatureParameter.getParameterValue(n);
        double d3 = this.scaleParameter.getParameterValue(0);
        double d4 = d3 * Math.pow(d, -0.25) * Math.exp(d2);
        this.rateParameter.setParameterValue(n, d4);
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        throw new RuntimeException("Look at code before running this class!");
    }
}

