/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxa;
import dr.evolution.util.TaxonList;
import dr.evomodel.coalescent.CoalescentSimulator;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class GibbsIndependentCoalescentOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String OPERATOR_NAME = "GibbsIndependentCoalescentOperator";
    public static final String HEIGHT = "height";
    private XMLObject xo;
    private TreeModel treeModel;
    private DemographicModel demoModel;
    private double rootHeight;
    private final dr.evolution.coalescent.CoalescentSimulator simulator = new dr.evolution.coalescent.CoalescentSimulator();
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("height", true, ""), new ElementRule(TreeModel.class), new ElementRule(DemographicModel.class), new ElementRule(Tree.class, 0, Integer.MAX_VALUE), new ElementRule(TaxonList.class, 0, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return GibbsIndependentCoalescentOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            DemographicModel demographicModel = (DemographicModel)xMLObject.getChild(DemographicModel.class);
            double d2 = xMLObject.getAttribute(GibbsIndependentCoalescentOperator.HEIGHT, Double.NaN);
            return new GibbsIndependentCoalescentOperator(xMLObject, treeModel, demographicModel, d2, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an independence coalescent sampler, disguised as a Gibbs operator, from a demographic model.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }
    };

    public GibbsIndependentCoalescentOperator(XMLObject xMLObject, TreeModel treeModel, DemographicModel demographicModel, double d, double d2) {
        this.xo = xMLObject;
        this.treeModel = treeModel;
        this.demoModel = demographicModel;
        this.rootHeight = d;
        this.setWeight(d2);
    }

    @Override
    public void setPathParameter(double d) {
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "GibbsIndependentCoalescent(" + this.treeModel.getModelName() + ")";
    }

    public int getStepCount() {
        return 1;
    }

    @Override
    public double doOperation() {
        int n;
        int n2;
        Object object;
        CoalescentSimulator coalescentSimulator = new CoalescentSimulator();
        ArrayList<TaxonList> arrayList = new ArrayList<TaxonList>();
        ArrayList<SimpleTree> arrayList2 = new ArrayList<SimpleTree>();
        for (int i = 0; i < this.xo.getChildCount(); ++i) {
            Object object2 = this.xo.getChild(i);
            if (object2 instanceof TreeModel) continue;
            if (object2 instanceof Tree) {
                Tree tree = (Tree)object2;
                object = new Tree[tree.getTaxonCount()];
                for (int j = 0; j < tree.getTaxonCount(); ++j) {
                    Taxa taxa = new Taxa();
                    taxa.addTaxon(tree.getTaxon(j));
                    object[j] = coalescentSimulator.simulateTree(taxa, this.demoModel);
                }
                SimpleTree simpleTree = coalescentSimulator.simulateTree((Tree[])object, this.demoModel, this.rootHeight, ((Tree[])object).length != 1);
                arrayList2.add(simpleTree);
                continue;
            }
            if (!(object2 instanceof TaxonList)) continue;
            arrayList.add((TaxonList)object2);
        }
        if (arrayList.size() == 0) {
            if (arrayList2.size() == 1) {
                Tree tree = (Tree)arrayList2.get(0);
                this.treeModel.beginTreeEdit();
                this.treeModel.adoptTreeStructure(tree);
                this.treeModel.endTreeEdit();
                return 0.0;
            }
            throw new RuntimeException("Expected at least one taxonList or two subtrees in " + this.getOperatorName() + " XML specification.");
        }
        Taxa taxa = new Taxa();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            taxa.addTaxa((TaxonList)arrayList.get(n2));
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            taxa.removeTaxa((TaxonList)arrayList2.get(n2));
        }
        Tree[] treeArray = new Tree[arrayList2.size() + taxa.getTaxonCount()];
        for (n = 0; n < arrayList2.size(); ++n) {
            treeArray[n] = (Tree)arrayList2.get(n);
        }
        for (n = 0; n < taxa.getTaxonCount(); ++n) {
            object = new Taxa();
            ((Taxa)object).addTaxon(taxa.getTaxon(n));
            treeArray[n + arrayList2.size()] = coalescentSimulator.simulateTree((TaxonList)object, this.demoModel);
        }
        SimpleTree simpleTree = coalescentSimulator.simulateTree(treeArray, this.demoModel, this.rootHeight, treeArray.length != 1);
        this.treeModel.beginTreeEdit();
        this.treeModel.adoptTreeStructure(simpleTree);
        this.treeModel.endTreeEdit();
        return 0.0;
    }
}

