/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.model.BooleanStatistic;
import dr.inference.model.Statistic;
import dr.oldevomodel.sitemodel.SampleStateAndCategoryModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class CategoryParameterStatistic
extends Statistic.Abstract
implements BooleanStatistic {
    private static String MINIMUM_NUMBER = "minimumNumber";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("name", "A name for this statistic for the purposes of logging"), AttributeRule.newIntegerRule(CategoryParameterStatistic.access$000()), new ElementRule(SampleStateAndCategoryModel.class)};

        @Override
        public String getParserName() {
            return "categoryParameterStatistic";
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            SampleStateAndCategoryModel sampleStateAndCategoryModel = null;
            String string = xMLObject.getAttribute("name", null);
            int n = xMLObject.getAttribute(MINIMUM_NUMBER, 0);
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof SampleStateAndCategoryModel)) continue;
                sampleStateAndCategoryModel = (SampleStateAndCategoryModel)xMLObject.getChild(i);
            }
            if (sampleStateAndCategoryModel == null) {
                throw new XMLParseException(this.getParserName() + " must contain a SampleStateAndCategoryModel.");
            }
            if (n < 1) {
                throw new XMLParseException(this.getParserName() + " minimum number must be greater than 0.");
            }
            return new CategoryParameterStatistic(string, sampleStateAndCategoryModel, n);
        }

        @Override
        public String getParserDescription() {
            return "A statistic that returns true if the minimum number of sites in a category are present";
        }

        @Override
        public Class getReturnType() {
            return CategoryParameterStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private int minimumNumber;
    private int categoryCount;
    private SampleStateAndCategoryModel siteModel;

    public CategoryParameterStatistic(String string, SampleStateAndCategoryModel sampleStateAndCategoryModel, int n) {
        super(string);
        this.minimumNumber = n;
        this.siteModel = sampleStateAndCategoryModel;
        this.categoryCount = sampleStateAndCategoryModel.getCategoryCount();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        for (int i = 0; i < this.categoryCount; ++i) {
            if (this.siteModel.getSitesInCategoryCount(i) >= this.minimumNumber) continue;
            return false;
        }
        return true;
    }
}

