/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.datatype.DataType;
import dr.evolution.sequence.Sequence;
import dr.evolution.sequence.UncertainSequence;
import dr.evoxml.util.DataTypeUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.logging.Logger;

public class AlignmentParser
extends AbstractXMLObjectParser {
    public static final String ALIGNMENT = "alignment";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new StringAttributeRule("dataType", "The data type", DataType.getRegisteredDataTypeNames(), false), new ElementRule(DataType.class)), new ElementRule(Sequence.class, 1, Integer.MAX_VALUE)};

    @Override
    public String getParserName() {
        return ALIGNMENT;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        SimpleAlignment simpleAlignment = new SimpleAlignment();
        DataType dataType = DataTypeUtils.getDataType(xMLObject);
        if (dataType == null) {
            throw new XMLParseException("dataType attribute expected for alignment element");
        }
        simpleAlignment.setDataType(dataType);
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Object object = xMLObject.getChild(i);
            if (object instanceof UncertainSequence) {
                simpleAlignment.addSequence((UncertainSequence)object);
                continue;
            }
            if (object instanceof Sequence) {
                simpleAlignment.addSequence((Sequence)object);
                continue;
            }
            if (object instanceof DataType) continue;
            throw new XMLParseException("Unknown child element found in alignment");
        }
        Logger logger = Logger.getLogger("dr.evoxml");
        logger.info("\nRead alignment" + (xMLObject.hasAttribute("id") ? ": " + xMLObject.getId() : "") + "\n  Sequences = " + simpleAlignment.getSequenceCount() + "\n      Sites = " + simpleAlignment.getSiteCount() + "\n   Datatype = " + simpleAlignment.getDataType().getDescription());
        return simpleAlignment;
    }

    @Override
    public String getParserDescription() {
        return "This element represents an alignment of molecular sequences.";
    }

    @Override
    public Class getReturnType() {
        return Alignment.class;
    }

    @Override
    public String getExample() {
        return "<!-- An alignment of three short DNA sequences -->\n<alignment missing=\"-?\" dataType=\"nucleotide\">\n  <sequence>\n    <taxon idref=\"taxon1\"/>\n    ACGACTAGCATCGAGCTTCG--GATAGCAGGC\n  </sequence>\n  <sequence>\n    <taxon idref=\"taxon2\"/>\n    ACGACTAGCATCGAGCTTCGG-GATAGCATGC\n  </sequence>\n  <sequence>\n    <taxon idref=\"taxon3\"/>\n    ACG?CTAGAATCGAGCTTCGAGGATAGCATGC\n  </sequence>\n</alignment>\n";
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

