% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climate_histories.R
\name{climate_histories}
\alias{climate_histories}
\title{Create Bclim climate_histories}
\usage{
climate_histories(slice_clouds, chronology, time_grid, n_mix = 10,
  mix_warnings = FALSE, n_chron = 2000, keep_parameters = TRUE,
  control_mcmc = list(iterations = 1e+05, burnin = 20000, thinby = 40, report
  = 100), control_chains = list(v_mh_sd = 2, phi1_mh_sd = 1, phi2_mh_sd = 10,
  v_start = statmod::rinvgauss(slice_clouds$n_slices - 1, 2, 1), Z_start =
  sample(1:n_mix, slice_clouds$n_slices, replace = TRUE), phi1_start = rep(3,
  slice_clouds$n_dimensions), phi2_start = rep(20, slice_clouds$n_dimensions)),
  control_priors = list(phi1_dl_mean = rep(1.275, slice_clouds$n_dimensions),
  phi1_dl_sd = rep(0.076, slice_clouds$n_dimensions), phi2_dl_mean = rep(4.231,
  slice_clouds$n_dimensions), phi2dl_sd = rep(0.271,
  slice_clouds$n_dimensions)))
}
\arguments{
\item{slice_clouds}{An object of class \code{slice_clouds} obtained from \code{\link{slice_clouds}}}

\item{chronology}{A set of chronologies given as a matrix. These should be provided in thousands of years before present. See details below}

\item{time_grid}{The time grid on which to create the climate histories}

\item{n_mix}{The number of mixture components for the Mclust mixture algorithm}

\item{mix_warnings}{Whether to display warnings related to the mixture algorithm}

\item{n_chron}{The number of chronologies to use}

\item{keep_parameters}{Whether to keep latent parameters or not. Useful for convergence checking so default is TRUE}

\item{control_mcmc}{A list containing elements that control the MCMC, including the number of iterations, the size of the burn-in period, the amount to thinby, and how often for the algorithm to report its progress}

\item{control_chains}{A list containing elements that control the starting values of the parameters (v_start, Z_start, phi1_start and phi2_start) and the Metropolis-Hastings proposal standard deviation for v, phi1 and phi2}

\item{control_priors}{A list containing the prior parameters for the volatilities, given by phi1 and phi2, both of which should be the log-mean and log-sd of the log-normal distribution. The values provided here are for the GISP2 ice core for the period 0 to 10k years BP}
}
\value{
A list object with the following elements
\itemize{
\item{v.store }{Samples of the posterior estimated volatilities}
\item{chron.store }{Samples of the used chronologies}
\item{c.store }{Samples of the posterior estimated climates}
\item{z.store }{Samples of the posterior mixture indices}
\item{phi1 }{Values used for the IG prior on v for each climate dimension}
\item{phi2 }{Values used for the IG prior on v for each climate dimension}
\item{chron.loc }{A character string giving the location of the chronology file}
\item{nchron }{The number of chronologies in the chronology file}
\item{parameters }{A list containing further latent parameter values for convergence checking (only if \code{keep_parameters} is TRUE)}
}
}
\description{
Runs a number of algorithms to create climate histories for a given set of slice clouds (from \code{\link{slice_clouds}} and a set of chronologies. For examples why not see the wonderful Bclim vignette (available at https://cran.r-project.org/web/packages/Bclim/index.html) and the author's personal webpage (https://maths.ucd.ie/parnell)?
}
\details{
This function takes the slice_clouds produced by \code{\link{slice_clouds}} uses a set of algorithms to produce climate histories on the provided time grid. The full details are in the paper referenced below. The options listed above allow quite a detailed level of control over the behaviour of the algorithm, and convergence should be checked using suitable means (see e.g. the R package boa or coda).

One of the key inputs to this function is a chronology. This should be a matrix of n_chron by n_slices containing sample chronologies as produced by, e.g. the R package Bchron. These are used by the \code{climate_histories} function to take account of chronological uncertainty. In the (unlikely) event that there is no chronological uncertainty, the rows of the chronologies can be identical.
}
\references{
Parnell, A. C., et al. (2015), Bayesian inference for palaeoclimate with time uncertainty and stochastic volatility. Journal of the Royal Statistical Society: Series C (Applied Statistics), 64: 115–138.
}
\seealso{
\code{\link{slice_clouds}} for producing the input for this function. See \code{\link{plot.climate_histories}} and  \code{\link{summary.climate_histories}} for plotting and summary details
}

