% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BchronDensity.R
\name{BchronDensity}
\alias{BchronDensity}
\title{Non-parametric phase model}
\usage{
BchronDensity(ages, ageSds, calCurves, pathToCalCurves = system.file("data",
  package = "Bchron"), dfs = rep(100, length(ages)), numMix = 50,
  iterations = 10000, burn = 2000, thin = 8, updateAges = FALSE,
  store_density = TRUE)
}
\arguments{
\item{ages}{A vector of ages (most likely 14C)}

\item{ageSds}{A vector of 1-sigma values for the ages given above}

\item{calCurves}{A vector of values containing either 'intcal13', 'shcal13', 'marine13', or 'normal'. Should be the same length the number of ages supplied. Non-standard calibration curves can be used provided they are supplied in the same format as those previously mentioned and are placed in the same directory. Normal indicates a normally-distributed (non-14C) age.}

\item{pathToCalCurves}{File path to where the calibration curves are located. Defaults to the system directory where the 3 standard calibration curves are stored}

\item{dfs}{Degrees-of-freedom values for the t-distribution associated with the calibration calculation. A large value indicates Gaussian distributions assumed for the 14C ages}

\item{numMix}{The number of mixture components in the phase model. Might need to be increased if the data set is large and the phase behaviour is very complex}

\item{iterations}{The number of iterations to run for}

\item{burn}{The number of starting iterations to discard}

\item{thin}{The step size of iterations to keep}

\item{updateAges}{Whether or not to update ages as part of the MCMC run. Default is FALSE. Changing this to TRUE will improve performance but will fit a slightly invalid model}

\item{store_density}{Whether or not to store the density and age grid. Useful for plotting the output in other packages}
}
\value{
An object of class BchronDensityRun with the following elements:
\itemize{
\item{theta}{The posterior samples of the restricted ages}
\item{p}{Posterior samples of the mixture proportions}
\item{mu}{Values of the means of each Gaussian mixture}
\item{calAges}{The calibrated ages from \code{\link{BchronCalibrate}}}
\item{G}{The number of mixture components. Equal to numMix}
\item{age_grid}{A grid of ages used for the final density estimate}
\item{density}{The density estimate based on the above age grid}
}
}
\description{
This function runs a non-parametric phase model on 14C and non-14C ages via Gaussian Mixture density estimation
}
\details{
This model places a Gaussian mixture prior distribution on the calibrated ages and so estimates the density of the overall set of radiocarbon ages. It is designed to be a probabilistic version of the Oxcal SUM command which takes calibrated ages and sums the probability distributions with the aim of estimating activity through age as a proxy.
}
\examples{
\dontrun{
# Read in some data from Sluggan Moss
data(Sluggan)

# Run the model
SlugDens = BchronDensity(ages=Sluggan$ages,ageSds=Sluggan$ageSds,
                         calCurves=Sluggan$calCurves)

# plot it
plot(SlugDens)
}
}
\seealso{
\code{\link{Bchronology}}, \code{\link{BchronRSL}}, \code{\link{BchronDensityFast}} for a faster approximate version of this function
}

