% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapping.R
\name{getBootstrapQuantiles}
\alias{getBootstrapQuantiles}
\title{getBootstrapQuantiles}
\usage{
getBootstrapQuantiles(bs_samples, quantiles)
}
\arguments{
\item{bs_samples}{An object of class bootstrappedSample as created by getBootstrapSamples}

\item{quantiles}{A vector of quantiles that should be evaluated}
}
\value{
A data frame with entries doses, models, and quantiles
}
\description{
Calculates quantiles from bootstrapped dose predictions.
Can be used to derive credible intervals to assess the uncertainty for the model fit.
}
\examples{
posterior_list <- list(Ctrl = RBesT::mixnorm(comp1 = c(w = 1, m = 0, s = 1), sigma = 2),
                       DG_1 = RBesT::mixnorm(comp1 = c(w = 1, m = 3, s = 1.2), sigma = 2),
                       DG_2 = RBesT::mixnorm(comp1 = c(w = 1, m = 4, s = 1.5), sigma = 2) ,  
                       DG_3 = RBesT::mixnorm(comp1 = c(w = 1, m = 6, s = 1.2), sigma = 2) ,
                       DG_4 = RBesT::mixnorm(comp1 = c(w = 1, m = 6.5, s = 1.1), sigma = 2))
models         <- c("exponential", "linear")
dose_levels    <- c(0, 1, 2, 4, 8)
fit            <- getModelFits(models      = models,
                               posterior   = posterior_list,
                               dose_levels = dose_levels,
                               simple      = TRUE)
                               
bs_samples     <- getBootstrapSamples(model_fits = fit,
                                      n_samples  = 10, # speeding up example run time
                                      doses      = c(0, 6, 8))
                           
getBootstrapQuantiles(bs_samples = bs_samples,
                      quantiles  = c(0.025, 0.5, 0.975))
}
