% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMCPMod.R
\name{getContr}
\alias{getContr}
\title{getContr}
\usage{
getContr(
  mods,
  dose_levels,
  dose_weights = NULL,
  prior_list = NULL,
  sd_posterior = NULL,
  se_new_trial = NULL
)
}
\arguments{
\item{mods}{An object of class 'Mods' as created by the function 'DoseFinding::Mods()'}

\item{dose_levels}{Vector containing the different dosage levels.}

\item{dose_weights}{Vector specifying weights for the different doses. Please note that in case this information is provided together with a prior (i.e. Option 1) is planned these two inputs should be provided on the same scale (e.g. patient numbers).  Default NULL}

\item{prior_list}{A list of objects of class 'normMix' as created with 'RBesT::mixnorm()'. Only required as input for Option 1. Default NULL}

\item{sd_posterior}{A vector of positive values with information about the variability of the posterior distribution, only required for Option 3. Default NULL}

\item{se_new_trial}{A vector of positive values with information about the observed variability, only required for Option 4. Default NULL}
}
\value{
An object of class 'optContr' as provided by the function 'DoseFinding::optContr()'.
}
\description{
This function calculates contrast vectors that are optimal for detecting certain alternatives via applying the function optContr() of the DoseFinding package.
Hereby 4 different options can be distinguished that are automatically executed based on the input that is provided
\enumerate{
\item Bayesian approach: If dose_weights and a prior_list are provided an optimized contrasts for the posterior sample size is calculated.
In detail,  in a first step the dose_weights (typically the number of patients per dose group) and the prior information is combined by calculating for
each dose group a posterior effective sample. Based on this posterior effective sample sizes the allocation ratio is derived, which allows for a calculation on
pseudo-optimal contrasts via regular MCPMod are calculated from the
regular MCPMod for these specific weights
\item Frequentist approach: If only dose_weights are provided optimal contrast vectors are calculated from the
regular MCPMod for these specific weights
\item Bayesian approach + re-estimation: If only a sd_posterior (i.e. variability of the posterior distribution) is provided, pseudo-optimal contrasts based on these posterior weights will be calculated
\item Frequentist approach+re-estimation:If only a se_new_trial (i.e. the estimated variability per dose group of a new trial) is provided, optimal contrast vectors are calculated from the
regular MCPMod for this specific vector of standard errors. For the actual evaluation this vector of standard errors is translated into a (diagonal) matrix of variances
}
}
\examples{
dose_levels  <- c(0, 0.5, 2, 4, 8)
mods <- DoseFinding::Mods(
  linear      = NULL,
  linlog      = NULL,
  emax        = c(0.5, 1.2),
  exponential = 2,
  doses       = dose_levels,
  maxEff      = 6)
sd_posterior <- c(2.8, 3, 2.5, 3.5, 4)

contr_mat <- getContr(
  mods         = mods,
  dose_levels  = dose_levels,
  sd_posterior = sd_posterior) 

}
