% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_message.R
\name{error_message}
\alias{error_message}
\title{Error Message for Data Format}
\usage{
error_message(h, NL)
}
\arguments{
\item{h}{A non-negative integer vector}

\item{NL}{A positive integer, indicating Number of lesions}
}
\value{
Plot of an error message by the generic function \code{plot()} for Shiny GUI.
}
\description{
Plot error messages to let user know his or her data format is wrong.
}
\details{
If \code{sum(h) > NL}, then an error message will appear.
The reason why the author uses the
generic funtion \code{plot} for error messages instead
of such as \code{message()} or \code{cat()}
is to preserve GUIs in \pkg{Shiny}.
So, this error message is shown in
some plot plane in the Graphical User Interface of \pkg{Shiny} in which  \code{message()} or \code{cat()} cannot use.
}
\examples{
#========================================================================================
#            If   number of hits > number of lesion,  then an error message appears.
#========================================================================================

 # Make an example such that sum(h) > NL, that is, the sum of the number of hits is
 # greater than the number of lesion, then, it launches an error message.

         h  <- c(50,30,20)
         NL <- 3


         error_message(h,NL)

 # Then, in an imaging device, an error message appears, because sum(h) = 100 > 3 = NL.
 # In Shiny, even if plot cannot be done causing some error, Graphical User Interface
 # can not change (now,... I can but.), so I have to use the graphical user interface.
 # Thus. in such case, I use this function rather than the message() or cat().

 # Who read this? My heart will be more empty when I wrote this mannual.

 # This function is made in 2019 July, 6.
 # Doc is reviesed in 2020 Feb




}
\seealso{
\code{ \link{fit_GUI}() }
}
