% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/validation_MRMC_Create_dataList_MRMC_Hit_from_rate_etc.R
\name{from_array_to_vector}
\alias{from_array_to_vector}
\alias{array}
\alias{to}
\alias{vector}
\title{Transform from an \strong{array} to a \strong{vector}}
\usage{
from_array_to_vector(Three.dim.array)
}
\arguments{
\item{Three.dim.array}{Three dimensional array, such as the number of hits for each confidence level, modality and reader. Or false alarms. Since the author construct the substituting data list as one dimensional (one index) array, it needs to reconstruct to the three indexed array  from one dimensional array whose subscript is [confidence level, modality, reader ] or vice versa.}
}
\value{
One dimensional array transformed from user input three dimensional array.
}
\description{
In stan files of this package,
the number of hits,
false alarms
and hit rates in binomial assumption for MRMC case
are written with \strong{the three indexed array} format.
 Three index indicates
 confidence levels, modality ID, reader ID.
However, hit data passed to
the function \code{BayesianFROC::\link{fit_Bayesian_FROC}()}
are written with \strong{the vector}.
So, in order to connect these different format, (i.e. vector and array, ) the author made this function.
}
\examples{
\donttest{
  h.array.etc <- hits_from_thresholds()

  h.vector     <- from_array_to_vector(h.array.etc$h)





  a <- array_easy_example()
  a.vector <- from_array_to_vector(a)

  # Revised 2019 August 20


  }
}
