% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbc.R
\name{Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc}
\alias{Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc}
\title{Simulation Based Calibration (SBC)
 for a single reader and a single modality case}
\usage{

  Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(ww = -0.81,
  www = 0.001, mm = 0.65, mmm = 0.001, vv = 0.05, vvv = 0.1,
  zz = 1.55, zzz = 0.001, epsilon = 0.001, XXX = 1, YYY = 1,
  ite = 3333, model_reparametrized = FALSE, NL = 259, NI = 57,
  C = 3, prior = 1, M = 500)
}
\arguments{
\item{ww}{A real number, representing a parameter of prior, indicating mean of prior for the first threshold}

\item{www}{A real number, representing a parameter of prior, variance of prior for the first threshold}

\item{mm}{A real number, representing a parameter of prior, mean of prior for the mean of signal distribution}

\item{mmm}{A real number, representing a parameter of prior, variance of prior for the variance of signal distribution}

\item{vv}{A real number, representing a parameter of prior,  mean of prior for the mean of signal distribution}

\item{vvv}{A real number, representing a parameter of prior, variance of prior for the variance of signal distribution}

\item{zz}{A real number, representing a parameter of prior, mean of prior for the  differences of thresholds}

\item{zzz}{A real number, representing a parameter of prior, variance of prior for the  differences of thresholds}

\item{epsilon}{lower bound of Poisson for false positives.}

\item{XXX}{?}

\item{YYY}{?}

\item{ite}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}

\item{model_reparametrized}{A logical, if TRUE, then a model under construction is used.}

\item{NL}{number of lesions}

\item{NI}{number of images}

\item{C}{number of confidence levels}

\item{prior}{An integer, representing type of priors}

\item{M}{To be passed to the function \code{rstan::}\code{\link[rstan]{sbc}}() in \strong{rstan}.}
}
\value{
A list of S3 class "sbc", which is an output of  the function \code{rstan::sbc()}  in \pkg{rstan}.
}
\description{
Implements the SBC algorithm for
  a single reader and a single modality case.
}
\details{
The implementation is
 done using the rstan::sbc. The stan file is \code{SBC.stan}
The implementation is done using the function \code{rstan::sbc}.
The stan file is \code{SBC.stan}
The variable in this function is a collection of parameters of priors


 If we use non-informative prior, then from the prior the odd model parameter are generated.
For example,
If two thresholds z[c] and z[c+1] agree for some c, then  the false alarm rate becomes zero with the following error from \code{rstan::sbc}:




\code{ failed to create the sampler; sampling not done}

\code{  Error in new_CppObject_xp(fields$.module, fields$.pointer, ...) :}

\code{  Exception: poisson_rng: Rate parameter is 0, but must be > 0!}



\strong{Thus, we have to use very strong prior to avoid to generate  such odd parameters of model.}




SBC is a validation algorithm for models with respect to its prior.

I cannot fine the prior in which we can fit a model to various datasets.

\strong{What is SBC?}

Aim of SBC is to evaluate \emph{how} the computed posteriors are incorrect.
To do so, SBC algorithm makes a histogram whose uniformity indicates MCMC samples contains bias.

For example,


If histogram is concave, namely there are spikes at the boundaries of histogram,
then it indicates that MCMC samples is correlated.
If a histogram is convex ( \eqn{\cap}-shaped), then it indicates that
over-dispersed posteriors relative to the \strong{true} posterior.

\describe{
\item{if histogram is concave, }{ namely there are spikes at the boundaries of histogram,then it indicates that MCMC samples is correlated.}
\item{ If a histogram is convex ( \eqn{\cap}-shaped), }{ then it indicates that over-dispersed posteriors relative to the \strong{true} posterior.}
\item{ If a histogram is  weighted to right or left,}{ then posterior moves opposite direction, namely left or right respectively.}
}




We may say that SBC is a statistical test of the null hypothesis \eqn{H_0}:

 \deqn{H_0: MCMC sampling is correct. }

If the histogram is far from uniformity, then we reject \eqn{H_0} and say that
MCMC sampling contains bias.







\emph{\strong{Parameters of our model}}

\describe{
\item{ \code{w} }{ The first threshold}
\item{  \code{dz} }{ The difference of thresholds, that is, dz[c]:= z[c+1]-z[c]}
\item{  \code{ m}  }{Mean of signal Gaussian}
\item{   \code{v } }{Variance of signal Gaussian}
}
}
\examples{


#----------------------------------------------------------------------------------------
#                                SBC via rstan::sbc
#----------------------------------------------------------------------------------------


#  Provides an Simulations Based Calibration for validation of our sampling.
#  We can confirmed that my model has very exact MCMC sampling.
#  SBC require suitable priors, and for the author, it seems very informative priors.
#  If we do not use the informative priors, then the odd data are generated from
#  the likelihood at the parameters drawn from priors. Such odd data has not fitted
#  our model, causing odd sampling.
#  If we do not choose the informative priors in suitable way, then it causes bias
#  in model. Even if the MCMC sampling is good in the sense of SBC, but the choice of
#  priors has no reason, then it will cause bias. So, the author of this package
#  guess that  the bias of MCMC sampling and the bias of priors are trade off.
#  I write this program with no good condition of health or not good environment,
#  not enough money. So I write this with pain, pain in body, pain in life, pain in
#  money. So, this program let me be happy? I have to live. I must live.
#


# The default is three confidence levels,

\donttest{
#----------------------------------------------------------------------------------------
#                              Default prior
#----------------------------------------------------------------------------------------



 Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc()




#----------------------------------------------------------------------------------------
#                              Default prior
#----------------------------------------------------------------------------------------




 Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(prior = 1)




#----------------------------------------------------------------------------------------
#                              Default prior
#----------------------------------------------------------------------------------------



#----------------------------------------------------------------------------------------
#                                SBC via rstan::sbc
#----------------------------------------------------------------------------------------

fit<-Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
               ww=-0.81,www =0.001,
               mm=0.65,mmm=0.001,
               vv=5.31,vvv=0.001,
               zz= 1.55,zzz=0.001 )

#----------------------------------------------------------------------------------------
#                                SBC via rstan::sbc
#----------------------------------------------------------------------------------------


# The following example, we specify the variance of prior of first thresholds
# as 1 which is  very large for variance. If we take more large variance,
# then Stan cannot start sampling since its

# Run SBC algorithm
fit <-
Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(www=1)


# Check uniformity intuitively
plot(fit,bins=10)# Not required since the above funtion also plot the rank statistics.

#----------------------------------------------------------------------------------------
#        Using default variables             SBC via rstan::sbc
#----------------------------------------------------------------------------------------

# Run SBC algorithm
fit <-
Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc()


# Check uniformity intuitively

plot(fit,bins=10)

#----------------------------------------------------------------------------------------
#      Number of confidence level is 4        SBC via rstan::sbc
#----------------------------------------------------------------------------------------
#         Run SBC algorithm


fit <-
Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbcv(C=4)


#        Check uniformity intuitively



        plot(fit,bins=11)






#  Note that using this prior, the author attempt to fit a model to data named d,
#  but, model did not converge since the prior is too informative.
#  SBC procedure use prior for drawing samples, so, non-informative prior causes
#  odd data, and FROC model cannot fit such a odd dataset. So,
#  even if SBC said it is good with respect to some prior, but such prior cannot
#  use the general fitting procedure. The author emphasizes that the SBC and
#  model fitting to any data is trade off.
#  Thus, I cannot use this SBC prior for the stan file since it is too informative
#                 2019 August 30


# Strong informative  prior leads us to lack of versatility.
# However, SBC does not detect or ignore such versatility.




#----------------------------------------------------------------------------------------
#   To obtain Large variance
#----------------------------------------------------------------------------------------



# The following histogram has singular on both boundary.

 Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
                www = 1,
                vvv = 1,
                mmm = 1
                )





# The following SBC is good even if, it sometimes fails,
# since Poisson rate becomes sometimes zero:

 Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
          www = 1,
          vvv = 1,
          zzz = 1
          )


#----------------------------------------------------------------------------------------
# SBC failed but adding new prior so that Poisson rate is not zero,
# then, it is good SBC histogram.
#----------------------------------------------------------------------------------------


 Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
   www = 1,
   vvv = 1,
   zzz = 1
   )




#----------------------------------------------------------------------------------------
# SBC failed: Very small samples for the histogram
#----------------------------------------------------------------------------------------

Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
  www = 11,
  vvv = 11,
  zzz = 11,

  prior = -1
)

 Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
   www = 11,
   vvv = 11,
   zzz = 11
   )


 Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
   www = 5,
   vvv = 5,
   zzz = 5
   )



Simulation_Based_Calibration_single_reader_single_modality_via_rstan_sbc(
  www = 2,
  vvv = 2,
  zzz = 2
)
# The last is subtle, but not so bad.




# I change the model, so the above consideration will change. 2019 Oct. 6

}#donttest

}
\references{
Talts, S., Betancourt, M., Simpson, D., Vehtari, A., and Gelman, A. (2018). Validating Bayesian Inference Algorithms with Simulation-Based Calibration. arXiv preprint arXiv:1804.06788. https://arxiv.org/abs/1804.06788



\strong{\emph{ data Format:}}

 \emph{            A single reader and a single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{definitely} present  \tab  \code{c[1] = }5 \tab \code{f[1] = }\eqn{F_5} = 1 \tab  \code{h[1] = }\eqn{H_5} = 41 \cr
 \emph{probably} present   \tab  \code{c[2] = }4 \tab \code{f[2] = }\eqn{F_4} = 2 \tab  \code{h[2] = }\eqn{H_4} = 22 \cr
 equivocal                 \tab  \code{c[3] = }3 \tab \code{f[3] = }\eqn{F_3} = 5 \tab  \code{h[3] = }\eqn{H_3} = 14  \cr
 subtle                    \tab  \code{c[4] = }2 \tab \code{f[4] = }\eqn{F_2} = 11 \tab \code{h[4] = }\eqn{H_2} = 8  \cr
 \emph{very} subtle        \tab  \code{c[5] = }1 \tab \code{f[5] = }\eqn{F_1} = 13 \tab \code{h[5] = }\eqn{H_1} = 1  \cr
 }

---------------------------------------------------------------------------------------------------


Recall our model for the above data format;


  \deqn{ H_5 \sim Binomial (p_5,N_L )}
  \deqn{ H_4 \sim Binomial (p_4,N_L )}
  \deqn{ H_3 \sim Binomial (p_3,N_L )}
  \deqn{ H_2 \sim Binomial (p_2,N_L )}
  \deqn{ H_1 \sim Poisson (p_1,N_L )}
  \deqn{ F_5 \sim Poisson (q_5 )}
  \deqn{ F_4 \sim Poisson (q_4 )}
  \deqn{ F_3 \sim Poisson (q_3 )}
  \deqn{ F_2 \sim Poisson (q_2 )}
  \deqn{ F_1 \sim Poisson (q_1 )}









where
\deqn{ p_5= p_5(z_1,...z_C; \mu, \sigma) = \int_{z5}^{\infty} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_4=p_4(z_1,...z_C; \mu, \sigma) = \int_{z4}^{5} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_3=p_3(z_1,...z_C; \mu, \sigma) = \int_{z3}^{4} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_2=p_2(z_1,...z_C; \mu, \sigma) = \int_{z2}^{3} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_1=p_1(z_1,...z_C; \mu, \sigma) = \int_{z1}^{2} Gaussian(z|\mu,\sigma)dz}

\deqn{ q_5=q_5(z_1,...z_C) = \int_{z5}^{\infty}  d \log \Phi (z)}
\deqn{ q_4=q_4(z_1,...z_C) = \int_{z4}^{5}  d \log \Phi (z)}
\deqn{ q_3=q_3(z_1,...z_C) = \int_{z3}^{4}  d \log \Phi (z)}
\deqn{ q_2=q_2(z_1,...z_C) = \int_{z2}^{3}  d \log \Phi (z)}
\deqn{ q_1=q_1(z_1,...z_C) = \int_{z1}^{2}  d \log \Phi (z)}


\strong{Priors}


\deqn{w ~  normal(ww,www);}
\deqn{dz[c] ~  normal(zz,zzz)I_{[0,\infty]};c=1,2,...,C}
\deqn{m ~ normal(mm,mmm);}
\deqn{v ~ normal(vv,vvv);}

where \code{dz[c]=z[c+1]-z[c]}.

The variable of this function is the parameters of the priors, namely:

\deqn{ww,www,zz,zzz,mm,mmm,vv,vvv.    Revised 2019 August 30}




In SBC, we have to specify proper priors, thus, we use the above priors.
So, what reader should do is to specify the above parameters, that is,
\code{ww,www,zz,zzz,mm,mmm,vv,vvv} and further a number of images\code{NL}
and a number of lesion \code{NI} and a number of confidence levels should specify.
In the above example data format, the number of confidence level is the number of rows,
and now it is 5, that is \code{C=5}.

 Revised 2019 August 4







I am not statistician nor researcher nor human. My leg is gotten by death who is prurigo nodularis.
Death is soon. I cannot understand, I hate statistics. I do not want to waste my time to this FROC analysis.
My program is volunteer, I am no money no supported. Completely my own support or my parents. Completely my own.
I am tired for this no end point running. I have not money to research or place or circumstance.
No healthy condition. This program is made with my blood and pain, great pain. I no longer want to live.
I hate all. Honesty.
}
