% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertFromJafroc.R
\name{convertFromJafroc}
\alias{convertFromJafroc}
\title{Convert  \code{.xlsx} File Of \strong{\emph{Jafroc}}  Into \R Object}
\format{The \code{.xlsx} file of Jafroc must include three sheets named by \strong{\emph{TP, FP, Truth}} (other names never be permitted !!)


\strong{\emph{-----------------------------------  TP ------------------------------------------}}


A sheet named \strong{\emph{TP}}  includes five columns \strong{\emph{ precisely }}  named from the right hand side:

\strong{\emph{ReaderID,	ModalityID,	CaseID,	LesionID,	TP_Rating.}}

1) Note that the above word CaseID means the Image ID vectors indicating the ID of radiographs.
   That is "case = image = radiograph".
2) Note that the first row of \code{.xlsx} sheet devote for the names as follows:

\strong{An Example of a sheet named \emph{TP} in a \emph{\code{.xlsx}} file for the \emph{Jafroc} software}

\tabular{ccccc}{
  ReaderID \tab   ModalityID   \tab   CaseID \tab   LesionID \tab   TP_Rating.\cr
  -------------------\tab-------------------\tab-------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab 1 \tab  1\tab 5\cr
  1 \tab 2 \tab 2  \tab 1\tab 4\cr
  1 \tab 3 \tab 4  \tab 1\tab 5\cr
  1 \tab 1 \tab 8  \tab 1\tab 3\cr
  1 \tab 2 \tab 8  \tab 2\tab 4\cr
  1 \tab 3 \tab 9  \tab 1\tab 4\cr
  1 \tab 1 \tab 9  \tab 2\tab 3\cr
  1 \tab 2 \tab 9  \tab 3\tab 5\cr
  1 \tab 3 \tab 11 \tab 1\tab 3\cr
  2 \tab 1 \tab 1 \tab  1\tab 4\cr
  2 \tab 2 \tab 4  \tab 1\tab 4\cr
  2 \tab 3 \tab 5  \tab 1\tab 4\cr
  2 \tab 1 \tab 8  \tab 1\tab 1\cr
  2 \tab 2 \tab 8  \tab 2\tab 2\cr
  2 \tab 3 \tab 8  \tab 3\tab 2\cr
  2 \tab 1 \tab 10  \tab 1\tab 3\cr
  2 \tab 2 \tab 10 \tab 2\tab 2\cr
  2 \tab 3 \tab 11  \tab 1\tab 2\cr

  : \tab : \tab :  \tab :\tab :\cr
  : \tab : \tab :  \tab :\tab :\cr    }


\strong{\emph{-----------------------------------  FP ------------------------------------------}}



A sheet named \strong{FP}  includes four columns  \strong{\emph{ precisely }}  named from the right hand side: \strong{ReaderID,	ModalityID,	CaseID,	FP_Rating}
\strong{An Example of a sheet named FP in a \code{.xlsx} file for the Jafroc software}

\tabular{cccc}{
  ReaderID \tab   ModalityID   \tab   CaseID  \tab   FP_Rating.\cr
-------------------\tab-------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab 1 \tab   2\cr
  1 \tab 2 \tab 2  \tab  1\cr
  1 \tab 3 \tab 3  \tab  1\cr
  1 \tab 1 \tab 5  \tab  2\cr
  1 \tab 2 \tab 7 \tab   1\cr
  1 \tab 3 \tab 7  \tab   2\cr
  1 \tab 1 \tab 9  \tab   3\cr
  1 \tab 2 \tab 9  \tab   4\cr
  1 \tab 3 \tab 10 \tab   1\cr
  2 \tab 1 \tab 1 \tab    2\cr
  2 \tab 2 \tab 2  \tab   3\cr
  2 \tab 3 \tab 3  \tab   4\cr
  2 \tab 1 \tab 8  \tab   1\cr
  2 \tab 2 \tab 9  \tab  1\cr
  2 \tab 3 \tab 11  \tab   1\cr
  2 \tab 1 \tab 14  \tab  1\cr
  2 \tab 2 \tab 15 \tab   1\cr
  2 \tab 3 \tab 21  \tab   2\cr
  : \tab :  \tab :\tab :\cr
  : \tab :  \tab :\tab :\cr
     }




\strong{\emph{-----------------------------------  Truth ------------------------------------------}}

A sheet named \strong{Truth }  includes three columns  \strong{\emph{ precisely }}  named from the right hand side:\strong{CaseID,	LesionID,	Weight} .

\strong{An Example of a sheet named Truth in a \code{.xlsx} file for the Jafroc software}
\tabular{ccc}{
  CaseID \tab   LesionID   \tab     Weight\cr
  -------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab    0.3333...\cr
  1 \tab 2 \tab    0.3333...\cr
  1 \tab 3 \tab    0.3333...\cr
  2 \tab 1 \tab    0.5\cr
  2 \tab 2 \tab    0.5\cr
  3 \tab 1 \tab    1\cr
  4 \tab 1 \tab    0.25\cr
  4 \tab 2 \tab    0.25\cr
  4 \tab 3 \tab    0.25\cr
  4 \tab 4 \tab    0.25\cr
  5 \tab 1 \tab    0.5\cr
  5 \tab 2 \tab    0.5\cr
  6 \tab 1 \tab    0.3333...\cr
  6 \tab 2 \tab    0.3333...\cr
  6 \tab 3 \tab    0.3333...\cr
  7 \tab 1 \tab    0.3333...\cr
  7 \tab 2 \tab    0.3333...\cr
  7 \tab 3 \tab    0.3333...\cr
  8 \tab 1 \tab    0.25\cr
  8 \tab 2 \tab    0.25\cr
  8 \tab 3 \tab    0.25\cr
  8 \tab 4 \tab    0.25\cr
  :  \tab :\tab :\cr
  :  \tab :\tab :\cr
  }






Never change from these column names in any \code{.xlsx} file.


Note that the weght are used for each images influence a same effect on the esimates.
If we consider the truth without weight, then the images including many targets (lesions) has very strong effect on the estimates.
To avoid such bias, Jafroc uses weight. However, in this package, we do not use the information of weight.
Since the theory of the author of this package did not consider such weight. In the future I have to include the notion of weight.
Jafroc use the notion fo figure of metric as non parametric manner.
So, it seems difficult to include it in the Bayesian model, since generally speaking, Bayesian methodology is parametric.}
\usage{
convertFromJafroc(No.of.Modalities, No.of.readers, No.of.confidence.levels)
}
\arguments{
\item{No.of.Modalities}{Number of \emph{modalities}.}

\item{No.of.readers}{Number of \emph{readers}.}

\item{No.of.confidence.levels}{The number of \emph{confidence levels}.}
}
\value{
A list, representing FROC data, which is available to succe
}
\description{
Create a passing dataset to  the  function \code{ \link{fit_Bayesian_FROC}}.

Convert an Excel file whose extension is \code{.xlsx} of Jafroc format to
  an \R object representing FROC data to which we will apply functions in this package such as  \code{\link{fit_Bayesian_FROC}()}.

\strong{\emph{Convert an FROC dataset containing observer's performance}}
\describe{

\item{         \strong{\emph{from}}    }{ \code{.xlsx} file of \strong{\emph{Jafroc}}  }
\item{        \strong{\emph{into}}     }{ \R object   }
}
}
\details{
Revised 2019 Jun 19

The return values include the data list which are directly available to the main function \code{fit_Bayesian_FROC}.
So, if user has data of Jafroc, then by running this function, user immediately can fit the author's Bayesian FROC model to the resulting \R object.

The Jafroc software's format includes suspicious locations of readers and true locations.
Such data is \emph{redundant} for our Bayesian statistical models.
So, we reduce the information of data to the number of
false positives and number of hits for each confidence levels by this function.

\strong{minor comment or regret}
The author said the Jafroc data is redundant, but I should say more informative, and it cause limitation of our model.
So, our model start to fit a model to this reduced data from Jafroc. So, redunction will cause the non accuracy evaluation of observer performance.
The future research I should start the Jafroc formulation to build model not the \R object of this function.
}
\examples{

\donttest{
#--------------------------------------------------------------------------------------
#                  Example for convert the Jafroc data to the BayesianFROC
#--------------------------------------------------------------------------------------

# Work Flow of this example

# step 0) Prepare Jafroc .xlsx file being contained in this package
# step 1) Convert the .xlxs file obtained in step 0)
# step 2) Fit model to the data object obtained in step 1)












#--------------------------------------------------------------------------------------
#         step 0)      Make a Jafroc data
#--------------------------------------------------------------------------------------

# If you can search the xlsx file named JAFROC_data.xlsx
# in the director "inst/extdata" of this package,
# Then this step 0) is redundant. The author prepare this example for the people who
# cannot search the xlsx file in the  "inst/extdata" of this package.




# By an xlsx file named JAFROC_data.xlsx in the director "inst/extdata" of this package,
# we can reconstruct it  as follows:(If someone can obtain the Excel file
# from the path BayesianFROC/inst/extdata/JAFROC_data.xlsx, then the following code
# is not required to run. If searching bother you, then run the R script to obtain the
# Excel file.)
# I do not know how to users refer the JAFROC_data.xlsx in this package,
# so I provide it by making the same xlsx file as the JAFROC_data.xlsx.


# Note that JAFROC_data.xlsx cannot remove,
# if it is removed, then devtools::run_examples() make an error.

Truth <- readxl::read_excel(system.file("extdata",
 "JAFROC_data.xlsx",
  package="BayesianFROC"),
   sheet = "Truth")
View(Truth)

TP <- readxl::read_excel( system.file("extdata",
                                      "JAFROC_data.xlsx",
                                       package="BayesianFROC"),
                           sheet = "TP")
View(TP)

FP <- readxl::read_excel( system.file("extdata",
                                      "JAFROC_data.xlsx",
                                        package="BayesianFROC"),
                          sheet = "FP")
View(FP)





sample <- list(TP=TP,FP=FP,Truth=Truth)
openxlsx::write.xlsx(sample,"JafrocDatasetExample.xlsx")




# Now, we get excel file named "JafrocDatasetExample.xlsx", which is same as
# the JAFROC_data.xlsx.
# whose format is available in the Jafroc software developed by Chakraborty.
# If you use your data, your data must has same format of "JafrocDatasetExample.xlsx".
# Note that other excel data must comply with the above format.

# Note that if you have proper format excel file for our package,
# this process does not need.




#    (0) From the above, we obtain  "JafrocDatasetExample.xlsx"
#    which is the multiple reader and multiple modality dataset
#    for Jfroc analysis which is NOT implemented in our package,
#     but Chakraborty's software called Jafroc or the R package Rjafroc.




#--------------------------------------------------------------------------------------
#         step 1)      Convert a Jafroc data
#--------------------------------------------------------------------------------------

# (1) Using "JafrocDatasetExample.xlsx" as an example excel file,
# we run the function to convert the excel file from Jafroc format
# to our format:



     dataList <- convertFromJafroc(
                                  No.of.Modalities =5,
                                  No.of.readers    =4,
                                  No.of.confidence.levels = 5
                                    )



# In the variable, there is no xlsx file, since it is selected by interactive manner.
# So, please select the xlsx file obtained in step 0) or if have your own Jafroc
# .xlsx file.

#--------------------------------------------------------------------------------------
#         step 2)     Fitting a model to the converted data
#--------------------------------------------------------------------------------------


#  (2)   Now, we obtain a data list as the return value.
#        Using this list, we run the function "fit_Bayesian_FROC":



          fit  <-  fit_Bayesian_FROC(dataList )





           } # Revised 2019. Jun 19

}
\references{
Bayesian Models for Free-response Receiver Operating Characteristic Analysis
}
\seealso{
Rjafroc, which is unfortunately not on CRAN, now  2019 Jun 19.
Or JAFROC software in the Chakarboty's Web page. Unfortunately, this software is no longer supported.

So, the time spent, my package will soon be not on the CRAN? I do not know.
}
\author{
Issei Tsunoda
}
