% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.BfMRI.sess.R
\name{is.BfMRI.sess}
\alias{is.BfMRI.sess}
\title{Validate a \code{"BfMRI.sess"} object.}
\usage{
is.BfMRI.sess(x)
}
\arguments{
\item{x}{The putative \code{"BfMRI.sess"} object.}
}
\value{
Logical. Is \code{x} a valid \code{"BfMRI.sess"} object?
}
\description{
Check if object is valid for a \code{"BfMRI.sess"} object.
}
\details{
A \code{"BfMRI.sess"} object is a list of length \eqn{S}, where \eqn{S} is
the number of sessions in the analysis. Each list entry corresponds to a
separate session, and should itself be a list with these named fields:
\itemize{
\item{"BOLD"}{\eqn{T \times V} BOLD matrix. Rows are time points; columns are data locations (vertices/voxels).}
\item{"design"}{\eqn{T \times K} matrix containing the \eqn{K} task regressors.}
\item{"nuisance"}{Optional. \eqn{T \times J} matrix containing the \eqn{L} nuisance regressors.}
}
In addition, all sessions must have the same number of data locations, \eqn{V}, and tasks, \eqn{K}.
}
\examples{
nT <- 180
nV <- 700 
BOLD1 <- matrix(rnorm(nT*nV), nrow=nT)
BOLD2 <- matrix(rnorm(nT*nV), nrow=nT)
onsets1 <- list(taskA=cbind(c(2,17,23),4)) # one task, 3 four sec-long stimuli
onsets2 <- list(taskA=cbind(c(1,18,25),4))
TR <- .72 # .72 seconds per volume, or (1/.72) Hz
duration <- nT # session is 180 volumes long (180*.72 seconds long)
design1 <- make_HRFs(onsets1, TR, duration)$design
design2 <- make_HRFs(onsets2, TR, duration)$design
x <- list(
 sessionOne = list(BOLD=BOLD1, design=design1),
 sessionTwo = list(BOLD=BOLD2, design=design2)
)
stopifnot(is.BfMRI.sess(x))

}
