# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Find the log of the determinant of Q_tilde
#'
#' @param kappa2 a scalar
#' @param in_list a list with elements Cmat, Gmat, and GtCinvG
#' @param n_sess the integer number of sessions
#' 
.logDetQt <- function(kappa2, in_list, n_sess) {
    .Call(`_BayesfMRI_logDetQt`, kappa2, in_list, n_sess)
}

#' Find the initial values of kappa2 and phi
#'
#' @param theta a vector of length two containing the range and scale parameters
#'   kappa2 and phi, in that order
#' @param spde a list containing the sparse matrix elements Cmat, Gmat, and GtCinvG
#' @param w the beta_hat estimates for a single task
#' @param n_sess the number of sessions
#' @param tol the stopping rule tolerance
#' @param verbose (logical) Should intermediate output be displayed?
#' 
.initialKP <- function(theta, spde, w, n_sess, tol, verbose) {
    .Call(`_BayesfMRI_initialKP`, theta, spde, w, n_sess, tol, verbose)
}

#' Perform the EM algorithm of the Bayesian GLM fitting
#'
#' @param theta the vector of initial values for theta
#' @param spde a list containing the sparse matrix elements Cmat, Gmat, and GtCinvG
#' @param y the vector of response values
#' @param X the sparse matrix of the data values
#' @param QK a sparse matrix of the prior precision found using the initial values of the hyperparameters
#' @param Psi a sparse matrix representation of the basis function mapping the data locations to the mesh vertices
#' @param A a precomputed matrix crossprod(X%*%Psi)
#' @param Ns the number of columns for the random matrix used in the Hutchinson estimator
#' @param tol a value for the tolerance used for a stopping rule (compared to
#'   the squared norm of the differences between \code{theta(s)} and \code{theta(s-1)})
#' @param verbose (logical) Should intermediate output be displayed?
#' 
.findTheta <- function(theta, spde, y, X, QK, Psi, A, Ns, tol, verbose = FALSE) {
    .Call(`_BayesfMRI_findTheta`, theta, spde, y, X, QK, Psi, A, Ns, tol, verbose)
}

#' Get the prewhitening matrix for a single data location
#'
#' @param AR_coeffs a length-p vector where p is the AR order
#' @param nTime (integer) the length of the time series that is being prewhitened
#' @param avg_var a scalar value of the residual variances of the AR model
#' 
.getSqrtInvCpp <- function(AR_coeffs, nTime, avg_var) {
    .Call(`_BayesfMRI_getSqrtInvCpp`, AR_coeffs, nTime, avg_var)
}

