% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme.R
\name{nlmeNDiff}
\alias{nlmeNDiff}
\title{Non-differential Generalized Linear Mixed Effects Model}
\usage{
nlmeNDiff(data, lower = 0.5, upper = 1, id = FALSE, ...)
}
\arguments{
\item{data}{a data frame containing the 2 by 2 data of the diagnostics table of exposure status for every study in a meta-analysis.
It contains at least 4 columns in the data named as following: \code{n11} indicates the true positives, \code{n01} the false positives,
\code{n00} the true negatives and \code{n10} the false negatives. Each column is a vector of same length,
which is the number of meta-analysis study results used in the model.}

\item{lower}{an optional argument specifying the lower bound assumption of Se and Sp. Default to 0.5 (or the lowest Se/Sp of all studies, whichever is lower), which provides the mild assumption that Se and Sp are better than chance.}

\item{upper}{an optional argument specifying the upper bound assumption of Se and Sp. Default to 1.}

\item{id}{a TRUE of FALSE argument indicating if the supplied data has a \code{sid} column that gives same studies
the same subject ID. Default to FALSE, which assumes that all studies have different IDs.}

\item{...}{optional parameters passed to \href{https://www.rdocumentation.org/packages/lme4/versions/1.1-18-1/topics/glmer}{glmer}.}
}
\value{
It returns an object of class \href{https://www.rdocumentation.org/packages/lme4/versions/1.1-18-1/topics/merMod-class}{mermod}. 
Besides generic class methods, \code{paramEst()} is implemented in \code{BayesSenMC} to get the parameter estimates used in the Bayesian misclassification model functions.
}
\description{
Fit a bivariate generalized linear mixed-effects model (GLMM) for non-differential sensitivity and specificity using the \code{glmer} function in \code{lme4}. 
Lower and upper bounds for Se and Sp can be specified according to the assumptions of the study.
}
\examples{
data(bd_meta)

mod <- nlmeNDiff(bd_meta, lower = 0)
}
