% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsps_map.R
\name{bsps_map}
\alias{bsps_map}
\title{bsps_map}
\usage{
bsps_map(data, mapTitle = "columnName")
}
\arguments{
\item{data}{data.}

\item{mapTitle}{title to add to the map, any string or 'columnName' to set it to the name of the data column.}
}
\description{
Implement the \code{\link[rworldmap]{mapCountryData}} function in a short and fast version.
}
\examples{
\donttest{
library(BayesSPsurv)

walter <- spduration::add_duration(Walter_2015_JCR,"renewed_war",
                                   unitID = "id", tID = "year",
                                   freq = "year", ongoing = FALSE)

walter <- BayesSPsurv::spatial_SA(data = walter, var_ccode = "ccode", threshold = 800L)

set.seed(123456)

model <- spatialSPsurv(
   duration  = duration ~ victory + comprehensive + lgdpl + unpko,
   immune    = atrisk ~ lgdpl,
   Y0        = 't.0',
   LY        = 'lastyear',
   S         = 'sp_id' ,
   data      = walter[[1]],
   N         = 1500,
   burn      = 300,
   thin      = 15,
   w         = c(1,1,1),
   m         = 10,
   form      = "Weibull",
   prop.varV = 1e-05,
   prop.varW = 1e-03,
   A         = walter[[2]]
)

bsps_map(data = model$W)

}
}
