% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_SA.R
\name{spatial_SA}
\alias{spatial_SA}
\title{spatial_SA}
\usage{
spatial_SA(data, var_ccode, threshold = 800L)
}
\arguments{
\item{data}{data.frame.}

\item{var_ccode}{name of the variable that contains the country codes.}

\item{threshold}{distance in kilometers.}
}
\value{
list. Contains database with variable sp_id (S) and matrix A.
}
\description{
Generates a spatial weights matrix (A) and sp_id (S). User defines units and adjacencies.
}
\examples{

walter <- spduration::add_duration(Walter_2015_JCR,"renewed_war",
                                   unitID = "ccode",
                                   tID = "year",
                                   freq = "year",
                                   ongoing = FALSE)

walter <- spatial_SA(data = walter,
                     var_ccode = "ccode",
                     threshold = 800L)
}
