% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsSphere-functions.R
\name{transX_sp}
\alias{transX_sp}
\title{Design matrix of \code{bsSphere}}
\usage{
transX_sp(Xlin, degree, knots, k, maxBasis, a_alpha, b_alpha)
}
\arguments{
\item{Xlin}{A numeric vector representing the linear predictor values
(\eqn{X'\theta}).}

\item{degree}{An integer scalar giving the polynomial degree of the B-spline.}

\item{knots}{A numeric vector of candidate internal knots.}

\item{k}{An integer scalar indicating how many elements of \code{knots} are active.}

\item{maxBasis}{An integer scalar giving the target number of columns of the
returned design matrix. If the raw B-spline basis has fewer than \code{maxBasis}
columns, the result is right-padded with zeros.}

\item{a_alpha}{A numeric scalar specifying the lower boundary knot.}

\item{b_alpha}{A numeric scalar specifying the upper boundary knot.}
}
\value{
A numeric matrix of dimension \code{length(Xlin) × maxBasis} containing the
B-spline basis (with intercept) constructed from the \code{k} knots and
boundary knots \code{c(a_alpha, b_alpha)}, zero-padded on the right if needed.
}
\description{
A \pkg{nimble} function that maps \eqn{X'\theta}
to a B-spline basis design matrix with pre-specified candidate knots and boundary knots.
}
\details{
The function takes a candidate knot vector \code{knots} and boundary knots set to \code{c(a_alpha, b_alpha)}.
The resulting basis matrix is right-padded with zeros to have exactly
\code{maxBasis} columns, which is convenient for models whose basis dimension
may change during estimation but must conform to a fixed maximum width.

This function is intended for internal development purposes and is not designed
for direct use by end users.
}
\seealso{
\code{\link{bsSphere}}, \code{\link{predict.bsimSpline}}
}
