BayesSYC <-
function(theta, beta, lambda, y, X, phi, li1, li2, num, n, betaprior, Sqsigmaprior, Recsigmaprior, betatype, Sqsigmatype)
{
     m <- length(theta)
     p <- length(beta)
     theta <- c(theta, rnorm((n-1)*m))
     beta <- c(beta, rnorm((n-1)*p))
     lambda <- c(lambda, runif(n-1))
     ai <- Recsigmaprior[1:m]
     bi <- Recsigmaprior[(m+1):(2*m)]
     ni <- Recsigmaprior[(2*m+1):(3*m)]
     li1 <- li1 - 1
     li2 <- li2 - 1
     s <- 0
     Sqsigma <- rgamma(n*m, shape = ai + (ni+1) / 2, rate = 1)
     if (Sqsigmatype == 0){
          a0 <- Sqsigmaprior[1]
          b0 <- Sqsigmaprior[2]
          Sqsigmav <- 1.0 / rgamma(n, shape = a0 + m / 2, rate = 1)
          result <- .C("BayesSYC", as.double(theta), as.double(beta), as.double(Sqsigmav), 
               as.double(Sqsigma), as.double(lambda), as.double(y), as.double(X), as.double(phi), 
               as.double(num), as.integer(li1), as.integer(li2), as.integer(n), as.integer(m), as.integer(p), 
               as.integer(length(li1)), as.double(betaprior), as.double(b0), as.double(c(bi, ni)), as.integer(betatype), 
               as.integer(Sqsigmatype), as.integer(s))
     }
     else{
          Sqsigmav <- 1.0 / rgamma(n, shape = m / 2 - 1, rate = 1)
          result <- .C("BayesSYC", as.double(theta), as.double(beta), as.double(Sqsigmav), 
               as.double(Sqsigma), as.double(lambda), as.double(y), as.double(X), as.double(phi), 
               as.double(num), as.integer(li1), as.integer(li2), as.integer(n), as.integer(m), as.integer(p),
               as.integer(length(li1)), as.double(betaprior), as.double(Sqsigmaprior), as.double(c(bi, ni)), as.integer(betatype), 
               as.integer(Sqsigmatype), as.integer(s))
     }
     result[[1]] <- array(result[[1]], c(m, n))
     result[[2]] <- array(result[[2]], c(p, n))
     result[[4]] <- 1.0 / array(result[[4]], c(m, n))
     MCMCsample <- list(theta = result[[1]], beta = result[[2]], Sqsigmav = result[[3]], 
          Sqsigma = result[[4]], lambda = result[[5]], rate = result[[21]] / (n-1), type = "SYC")
     MCMCsample
}
