% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MH_sample_post.R
\name{sample_post_nor_ref_marg_Psi}
\alias{sample_post_nor_ref_marg_Psi}
\title{Metropolis-Hastings algorithm for the normal distribution and the Berger and
Bernardo reference prior, where \eqn{\mathbf{\Psi}} is generated from the marginal
posterior.}
\usage{
sample_post_nor_ref_marg_Psi(X, U, Np)
}
\arguments{
\item{X}{A \eqn{p \times n} matrix which contains \eqn{n} observation vectors of
dimension \eqn{p}.}

\item{U}{A \eqn{p n \times p n} block-diagonal matrix which contains the
covariance matrices of observation vectors.}

\item{Np}{Length of the generated Markov chain.}
}
\value{
List with the generated samples from the joint posterior distribution
of \eqn{\mathbf{\mu}} and \eqn{\mathbf{\Psi}}, where the values of
\eqn{\mathbf{\Psi}} are presented by using the vec operator.
}
\description{
This function implements Metropolis-Hastings algorithm for drawing samples
from the posterior distribution of \eqn{\mathbf{\mu}} and \eqn{\mathbf{\Psi}}
under the assumption of the normal distribution when the Berger and Bernardo
reference prior is employed. At each step, the algorithm starts with
generating a draw from the marginal distribution of \eqn{\mathbf{\Psi}}.
}
