% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_dist.R
\name{expected_dist}
\alias{expected_dist}
\title{Expected value of metrics under a Mallows rank model}
\usage{
expected_dist(alpha, n_items, metric)
}
\arguments{
\item{alpha}{Non-negative scalar specifying the scale (precision) parameter in the Mallows rank model.}

\item{n_items}{Integer specifying the number of items.}

\item{metric}{Character string specifying the distance measure to use. Available options are \code{"kendall"}, \code{"cayley"}, \code{"hamming"}, \code{"ulam"} for \code{n_items<=95}, \code{"footrule"} for \code{n_items<=50} and \code{"spearman"} for \code{n_items<=14}.}
}
\value{
A scalar providing the expected value of the \code{metric} under the Mallows rank model with distance specified by the \code{metric} argument.
}
\description{
Compute the expectation of several metrics under the Mallows rank model.
}
\examples{
expected_dist(1, 5, metric = "kendall")
expected_dist(2, 6, metric = "cayley")
expected_dist(1.5, 7, metric = "hamming")
expected_dist(5, 30, "ulam")
expected_dist(3.5, 45, "footrule")
expected_dist(4, 10, "spearman")
}
\seealso{
Other rank functions: 
\code{\link{get_mallows_loglik}()},
\code{\link{rank_conversion}},
\code{\link{rank_distance}()},
\code{\link{rank_freq_distr}()},
\code{\link{sample_mallows}()}
}
\concept{rank functions}
