% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_exponent_sum}
\alias{get_exponent_sum}
\title{Get exponent in Mallows log-likelihood}
\usage{
get_exponent_sum(alpha, rho, n_items, rankings, metric)
}
\arguments{
\item{alpha}{Numeric value of the scale parameter}

\item{rho}{A ranking sequence}

\item{n_items}{Integer is the number of items in a ranking
A matrix of size \eqn{N }\eqn{\times}{x}\eqn{ n_items} of
rankings in each row. Alternatively, if \eqn{N} equals 1, \code{rankings}
can be a vector.}

\item{rankings}{A matrix of size \eqn{N }\eqn{\times}{x}\eqn{ n_items} of
rankings in each row. Alternatively, if \eqn{N} equals 1, \code{rankings}
can be a vector.}

\item{metric}{Character string specifying the distance measure to use.
Available options are \code{"kendall"}, \code{"cayley"}, \code{"hamming"},
\code{"ulam"}, \code{"footrule"} and \code{"spearman"}.}
}
\value{
Exponent in the Mallows log likelihood. Note that it does not include
the partition function, and since the partition function depends on \code{alpha},
this is not a likelihood per se.
}
\description{
Calculates the exponent Mallows log-likelihood given a set of rankings
and a given rank sequence.
}
\examples{
set.seed(101)
rho <- t(c(1, 2, 3, 4, 5, 6))
alpha <- 2
metric <- "footrule"
n_items <- 6
get_exponent_sum(
  alpha = alpha, rho = rho, n_items = length(rho), rankings = rho,
  metric = metric
)

# return 0 because you are comparing the consensus ranking with itself
# if you change alpha or metric, then the result shall remain as 0

rankings <- sample_mallows(
  rho0 = rho, alpha0 = alpha, n_samples = 10, burnin = 1000, thinning = 500
)

# depending on your seed, you will get a different collection of rankings in R and C++

get_exponent_sum(
  alpha = alpha, rho = rho,  n_items = n_items, rankings = rankings ,
  metric = metric
)
}
\author{
Anja Stein
}
\keyword{internal}
