% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{smc_mallows_new_users_partial}
\alias{smc_mallows_new_users_partial}
\title{SMC-Mallows new users partial}
\usage{
smc_mallows_new_users_partial(
  R_obs,
  n_items,
  metric,
  leap_size,
  N,
  Time,
  logz_estimate,
  mcmc_kernel_app,
  num_new_obs,
  alpha_prop_sd,
  lambda,
  alpha_max,
  aug_method,
  verbose = FALSE
)
}
\arguments{
\item{R_obs}{Matrix containing the full set of observed rankings of size n_assessors by n_items}

\item{n_items}{Integer is the number of items in a ranking}

\item{metric}{A character string specifying the distance metric to use in the
Bayesian Mallows Model. Available options are \code{"footrule"},
\code{"spearman"}, \code{"cayley"}, \code{"hamming"}, \code{"kendall"}, and
\code{"ulam"}.}

\item{leap_size}{leap_size Integer specifying the step size of the leap-and-shift
proposal distribution}

\item{N}{Integer specifying the number of particles}

\item{Time}{Integer specifying the number of time steps in the SMC algorithm}

\item{logz_estimate}{Estimate of the partition function, computed with
\code{\link{estimate_partition_function}} in the BayesMallow R package {estimate_partition_function}.}

\item{mcmc_kernel_app}{Integer value for the number of applications we apply the MCMC move kernel}

\item{num_new_obs}{Integer value for the number of new observations (complete rankings) for each time step}

\item{alpha_prop_sd}{Numeric value of the standard deviation of the prior distribution for alpha}

\item{lambda}{Strictly positive numeric value specifying the rate parameter
of the truncated exponential prior distribution of alpha.}

\item{alpha_max}{Maximum value of alpha in the truncated exponential
prior distribution.}

\item{aug_method}{A character string specifying the approach for filling in the missing data, options are "pseudolikelihood" or "random"}

\item{verbose}{Logical specifying whether to print out the progress of the
SMC-Mallows algorithm. Defaults to \code{FALSE}.}
}
\value{
a set of particles each containing a value of rho and alpha
}
\description{
Function to perform resample-move SMC algorithm where we receive new users with complete rankings
at each time step
}
