% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f2calc.R
\name{f2calc}
\alias{f2calc}
\title{Calculation of the f2 Statistic}
\usage{
f2calc(dis_data)
}
\arguments{
\item{dis_data}{A data frame containing the dissolution data. The first column of the data frame should denote
the group labels identifying whether a given dissolution belongs to the "reference" or "test" formulation group.
For a given dissolution run, the remaining columns of the data frame contains the individual run's dissolution
measurements sorted in time.}
}
\value{
The function returns the f2 statistic calculated from the observed dissolution data.
}
\description{
This function calculates the f2 statistic as described in Moore and Flanner (1996).
}
\note{
Use the plotdiss() function to visually check if it's appropriate to calculate the f2 statistic.
}
\examples{
### dis_data comes loaded with the package
f2calc(dis_data)

}
\references{
Moore, J.W. and Flanner, H.H. (1996). Mathematical comparison of distribution profiles. Pharmaceutical Technology, 20(6):64-74.
}
