% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetectCpObj.R
\name{plot.DetectCpObj}
\alias{plot.DetectCpObj}
\title{Plot estimated change points}
\usage{
\method{plot}{DetectCpObj}(
  x,
  y = NULL,
  plot_freq = FALSE,
  loss = "VI",
  maxNClusters = 0,
  nRuns = 16,
  maxZealousAttempts = 10,
  ...
)
}
\arguments{
\item{x}{an object of class \code{DetectCPObj}.}

\item{y, ...}{parameters of the generic method.}

\item{plot_freq}{if TRUE also the histogram with the empirical frequency of each change point is plotted.}

\item{loss}{The loss function used to estimate the final partition, it can be "VI", "binder", "omARI", "NVI", "ID", "NID".}

\item{maxNClusters}{maximum number of clusters in salso procedure.}

\item{nRuns}{number of runs in salso procedure.}

\item{maxZealousAttempts}{maximum number of zealous attempts in salso procedure.}
}
\value{
The function returns a ggplot object representing the detected change points. If \code{plot_freq = TRUE} is plotted also an histogram with the frequency of times that a change point has been detected in the MCMC chain.
}
\description{
The \code{plot} method plots the estimates change points estimated through the salso algorithm, for a \code{DetectCpObj} class object.
}
\examples{

data_mat <- matrix(NA, nrow = 3, ncol = 100)

data_mat[1,] <- as.numeric(c(rnorm(50,0,0.100), rnorm(50,1,0.250)))
data_mat[2,] <- as.numeric(c(rnorm(50,0,0.125), rnorm(50,1,0.225)))
data_mat[3,] <- as.numeric(c(rnorm(50,0,0.175), rnorm(50,1,0.280)))

out <- detect_cp(data = data_mat, n_iterations = 2500, n_burnin = 500,
                 params = list(q = 0.25, k_0 = 0.25, nu_0 = 4, S_0 = diag(1,3,3),
                               m_0 = rep(0,3), par_theta_c = 2, par_theta_d = 0.2,
                               prior_var_phi = 0.1), kernel = "ts")
plot(out)



}
