% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LT_RegenDose.R
\name{LT_RegenDose}
\alias{LT_RegenDose}
\title{Plots Lx/Tx as a function of the regenerative dose}
\usage{
LT_RegenDose(
  DATA,
  Path,
  FolderNames,
  SampleNames = FolderNames,
  Nb_sample,
  BinPerSample = rep(1, Nb_sample),
  SG = rep(TRUE, Nb_sample),
  sepDP = c(","),
  nrow = 3L,
  ncol = nrow
)
}
\arguments{
\item{DATA}{\link{list} (\strong{required}): list of objects \code{LT}, \code{sLT}, \code{ITimes}, \code{dLab}, \code{ddot_env}, \code{regDose}, \code{J}, \code{K}, \code{Nb_measurement}, #' provided by \link{Generate_DataFile} or \link{Generate_DataFile_MG} or \link{combine_DataFiles}.\code{DATA} can contain information from more than one sample.}

\item{Path}{\link{character} (\strong{required}): path to the project folder
(the same as the one used in \link{Generate_DataFile}  or \link{Generate_DataFile_MG} to provide \code{DATA})}

\item{FolderNames}{\link{character} (\strong{required}): vector of names of the sub-folders
containing the BIN-files, which were used by \link{Generate_DataFile} or \link{Generate_DataFile_MG}
to generate the \code{DATA} object.}

\item{SampleNames}{\link{character} (with default): Names of samples. To use if there is more than one bin file per sample.}

\item{Nb_sample}{\link{integer} (\strong{required}): ID number (in \verb{[1,Nb_sample]}) of the
sample selected for plotting L/T as a function of regenerative doses.
Required if the \code{DATA} object contains information for more than one sample.}

\item{BinPerSample}{\link{integer} (with default): integer vector (with default):
vector with the number of BIN files per sample, which was used in \link{Generate_DataFile} or
\link{Generate_DataFile_MG} to generate the \code{DATA} object.}

\item{SG}{\link{logical} (with default): vector to set the type of measurement for
each sample \code{length(SG)=Nb_sample}.If the sample of number ID equal to \code{i}, \code{SG[i]=TRUE}
if it is a Single-grain OSL measurements,
\code{SG[i]=FALSE} if it is a Multi-grain OSL measurements.}

\item{sepDP}{\link{character} (with default): column separator in the \code{DiscPos.csv}
file or in Disc.csv file. It must be the same separator for all samples,
for single-grain OSL measurements or multi-grain OSL measurements.}

\item{nrow}{\link{integer} (with default): controls the arrangement of the plots,
here the number of rows. Can be set to \code{NULL}.}

\item{ncol}{\link{integer} (with default): controls the arrangement of the plots,
here the number of columns. Can be set to \code{NULL}.}
}
\value{
Lx/Tx plots; there are as many plots as selected aliquots in the \code{DiscPos.csv} file.
There are 9 plots per page.
There is not interpolation.
}
\description{
This function plots \code{Lx/Tx} values as a function of regenerative dose,
for every selected aliquot and for each sample.
}
\details{
To fill \code{FolderNames} and \code{BinPerSample}, we refer to the \bold{Detail} section from the
\link{Generate_DataFile} or \link{Generate_DataFile_MG} function.
As well for a precise description of input \code{DATA}.
}
\examples{
## load data file generated by the function Generate_DataFile
data(DATA3,envir = environment())
path<- system.file("extdata/FER1", "", package="BayLum")
folder=""
samplename <- "FER1"
LT_RegenDose(
 DATA = DATA3,
 Path = path,
 FolderNames = folder,
 SampleNames = samplename,
 Nb_sample = 1,
 SG = FALSE)
}
\seealso{
\link{Generate_DataFile}, \link{Generate_DataFile_MG}
}
\author{
Claire Christophe, Sebastian Kreutzer, Anne Philippe, Guillaume Guérin
} 

\section{How to cite}{
Christophe, C., Kreutzer, S., Philippe, A., 2020. LT_RegenDose(): Plots Lx/Tx as a function of the regenerative dose. In: Christophe, C., Philippe, A., Kreutzer, S., Guerin, G., 2020. BayLum: Chronological Bayesian Models Integrating Optically Stimulated. R package version 0.2.0. https://CRAN.r-project.org/package=BayLum
}

