context("summarizeExperiments")

test_that("summarizeExperiments", {
  r = makeTestRegistry()
  p1 = addProblem(r, "one", 1)
  p2 = addProblem(r, "two", 2)
  a1 = addAlgorithm(r, "A", fun=function(static, dynamic) 1)
  a2 = addAlgorithm(r, "B", fun=function(static, dynamic) 1)
  addExperiments(r, c("one", "two"), c("A", "B"))
  d = summarizeExperiments(r)
  expect_true(is.data.frame(d) && nrow(d) == 4 && ncol(d) == 3)
  d = summarizeExperiments(r, ids=1)
  expect_true(is.data.frame(d) && nrow(d) == 1)
  d = summarizeExperiments(r, ids=integer(0L))
  expect_true(is.data.frame(d) && nrow(d) == 0)
  
  r = makeTestRegistry()
  p1 = addProblem(r, "p1", static=1)
  a1 = addAlgorithm(r, id="a1", fun=function(static, dynamic, alpha, beta) 1)
  a2 = addAlgorithm(r, id="a2", fun=function(static, dynamic, alpha, gamma) 2)
  ad1 = makeDesign(a1, exhaustive = list(alpha=1:2, beta=1:2))
  ad2 = makeDesign(a2, exhaustive = list(alpha=1:2, gamma=7:8))
  addExperiments(r, algo.designs=list(ad1, ad2), repls=2)
  d = summarizeExperiments(r)
  expect_true(is.data.frame(d) && nrow(d) == 2 && ncol(d) == 3)
  d = summarizeExperiments(r, show=c("algo", "alpha", "beta"))
  expect_true(is.data.frame(d) && nrow(d) == 4+2 && ncol(d) == 4)
})
