% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.ids.R
\name{save.ids}
\alias{save.ids}
\title{Save Identifications}
\usage{
save.ids(outfile = "identified.txt", ids)
}
\arguments{
\item{outfile}{character string to indicate outfile name.}

\item{ids}{object of class "BarcodingR", which contains identified taxon information.}
}
\value{
no value returned,but an output file.
}
\description{
Output identified results to an outfile.
}
\examples{


data(TibetanMoth) 
ref<-as.DNAbin(as.character(TibetanMoth[1:50,]))
que<-as.DNAbin(as.character(TibetanMoth[50:60,]))
bsi<-barcoding.spe.identify(ref, que, method = "fuzzyId")
bsi
save.ids(outfile="identified.txt",bsi)
}
\author{
Ai-bing ZHANG, PhD. CNU, Beijing, CHINA.
}
\references{
zhangab2008(at)mail.cnu.edu.cn
}
\seealso{
barcoding.spe.identify()
}
\keyword{save.ids}

