% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{changeSub}
\alias{changeSub}
\alias{changeSub,Arena-method}
\title{Change substances in the environment}
\usage{
changeSub(object, smax, mediac, unit = "mmol/cell")

\S4method{changeSub}{Arena}(object, smax, mediac, unit = "mmol/cell")
}
\arguments{
\item{object}{An object of class Arena.}

\item{smax}{A number or vector of numbers indicating the maximum substance concentration per grid cell.}

\item{mediac}{A character vector giving the names of substances, which should be added to the environment (the default takes all possible substances).}

\item{unit}{A character used as chemical unit to set the amount of the substances to be added (valid values are: mmol/cell, mmol/cm2, mmol/arena, mM)}
}
\description{
The generic function \code{changeSub} changes specific substances in the environment.
}
\details{
If nothing but \code{object} is given, then all possible substrates are initilized with a concentration of 0. Afterwards, \code{\link{changeSub}} can be used to modify the concentrations of specific substances.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena) #add all substances with no concentrations.
arena <- changeSub(arena,20,c("EX_glc(e)","EX_o2(e)","EX_pi(e)")) 
#add substances glucose, oxygen and phosphate
}
\seealso{
\code{\link{Arena-class}} and \code{\link{addSubs}}
}

