% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{extractMed}
\alias{extractMed}
\alias{extractMed,Eval-method}
\title{Function for re-constructing a medium concentrations from simulations}
\usage{
extractMed(object, time = length(object@medlist))

\S4method{extractMed}{Eval}(object, time = length(object@medlist))
}
\arguments{
\item{object}{An object of class Eval.}

\item{time}{A number giving the simulation step of interest.}
}
\value{
Returns a list containing concentration vectors of all medium substances.
}
\description{
The generic function \code{extractMed} re-constructs a list of vectors of medium concentrations from a simulation step in an \code{Eval} object.
}
\details{
Medium concentrations in slot \code{medlist} of an object of class \code{Eval} store only the changes of concentrations in the simulation process. The function \code{extractMed} reconstructs the original and uncompressed version of medium concentrations.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,10)
med5 <- extractMed(eval,5)
}
\seealso{
\code{\link{Eval-class}} and \code{\link{Arena-class}}
}

