% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{changeFobj}
\alias{changeFobj}
\alias{changeFobj,Human-method}
\title{Function for changing the objective function of the model}
\usage{
changeFobj(object, new_fobj, model, alg = "fba")

\S4method{changeFobj}{Human}(object, new_fobj, model, alg = "fba")
}
\arguments{
\item{object}{An object of class Human.}

\item{new_fobj}{A character vector giving the reaction name of the new objective function.}

\item{model}{The original model structure which is converted into a problem object used for the next optimization.}

\item{alg}{A character vector giving the algorithm which should be used for the optimization (default is flux balance analysis).}
}
\description{
The generic function \code{changeFobj} changes the objective function, which is used for the linear programming in \code{optimizeLP}.
}
\details{
To avoid the bias to just one particular objective function, the objective can be changed dynamically in this function.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
human <- Human(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
changeFobj(human,'EX_glc(e)',Ec_core)
}
\seealso{
\code{\link{Human-class}} and \code{\link{optimizeLP}}
}

