% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_CP.R
\name{test_CP}
\alias{test_CP}
\title{Perform 'cold start' prediction using BaTFLED algorthm for CP models}
\usage{
test_CP(d, m)
}
\arguments{
\item{d}{an input data object created with \code{input_data}}

\item{m}{a \code{CP_model} object created with \code{mk_model}}
}
\value{
Response tensor generated by multiplying the input data through the trained model
}
\description{
Perform 'cold start' prediction using BaTFLED algorthm for CP models
}
\examples{
data.params <- get_data_params(c('decomp=CP'))
toy <- mk_toy(data.params)
train.data <- input_data$new(mode1.X=toy$mode1.X[,-1],
                             mode2.X=toy$mode2.X[,-1],
                             mode3.X=toy$mode3.X[,-1],
                             resp=toy$resp)
model.params <- get_model_params(c('decomp=CP'))
toy.model <- mk_model(train.data, model.params)
toy.model$rand_init(model.params)

train(d=train.data, m=toy.model, new.iter=1, params=model.params)

resp <- test_CP(train.data, toy.model)
}

