% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im_2_mat.R
\name{im_2_mat}
\alias{im_2_mat}
\title{Plot heatmaps of two matrices in red and blue}
\usage{
im_2_mat(x1, x2, high = "red", xaxt = "n", yaxt = "n", scale = "col",
  absol = FALSE, sort = TRUE, center = FALSE, main1 = "", main2 = "",
  ...)
}
\arguments{
\item{x1}{matrix}

\item{x2}{matrix}

\item{high}{string of either 'red' or 'blue' used to show higher values}

\item{xaxt}{string indicating how to display the x axis. Suppress x axis with 'n'}

\item{yaxt}{string indicating how to display the y axis. Suppress y axis with 'n'}

\item{scale}{logical indicating whether the matrices should be z scaled to have 
columns with norm zero and standard deviation one.}

\item{absol}{logical indicating whether to take absolute value of the entries 
before plotting}

\item{sort}{logical indicating whether the columns of the matrix should 
be sorted in decreasing order of their means}

\item{center}{logical indicating wether to center ranges for x and y around zero}

\item{main1}{string to be used as the main title for the first matrix image}

\item{main2}{string to be used as the main title for the second matrix image}

\item{...}{other graphical parameters passed to image}
}
\value{
If \code{sort==TRUE} the ordering of the second matrix used to match columns.
}
\description{
Displays two heatmaps of matrices using red and blue colors. Options to scale
and sort as well as any other graphical parameters with ... Sorting attempts to match
columns between the two matrices using their correlation over rows. If \code{sort==TRUE}
then the new ordering for the second matrix is returned.
}
\examples{
par(mfrow=c(1,2))
im_2_mat(matrix(1:12, nrow=3, ncol=4),  matrix(13:24, nrow=3, ncol=4), sort=FALSE, scale=FALSE)
im_2_mat(matrix(1:12, nrow=3, ncol=4),  matrix(13:24, nrow=3, ncol=4), sort=TRUE, scale=FALSE)
im_2_mat(matrix(1:12, nrow=3, ncol=4),  matrix(13:24, nrow=3, ncol=4), sort=TRUE, scale=TRUE)
im_2_mat(matrix(1:12, nrow=3, ncol=4),  matrix(13:24, nrow=3, ncol=4), sort=FALSE, 
         scale=FALSE, center=TRUE)
}

