% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_definitions.R
\docType{class}
\name{jumpRegression-class}
\alias{jumpRegression-class}
\title{S4 class of model informations for the jump regression model}
\description{
Informations of model
  \eqn{y_i = f(t_i, N_{t_i}, \theta) + \epsilon_i} with
  \eqn{N_t\sim Pois(\Lambda(t, \xi)), \epsilon_i\sim N(0,\gamma^2\widetilde{s}(t))}.
}
\section{Slots}{

\describe{
\item{\code{theta}}{parameter \eqn{\theta}}

\item{\code{gamma2}}{parameter \eqn{\gamma^2}}

\item{\code{xi}}{parameter \eqn{\xi}}

\item{\code{fun}}{function \eqn{f(t, N, \theta)}}

\item{\code{sT.fun}}{function \eqn{\widetilde{s}(t)}}

\item{\code{Lambda}}{function \eqn{\Lambda(t,\xi)}}

\item{\code{prior}}{list of prior parameters}

\item{\code{start}}{list of starting values for the Metropolis within Gibbs sampler}
}}
\examples{
parameter <- list(theta = c(3, 1), gamma2 = 0.1, xi = c(2, 0.2))
fun <- function(t, N, theta) theta[1]*t + theta[2]*N
sT.fun <- function(t) t
Lambda <- function(t, xi) (t / xi[2])^xi[1]
prior <- list(m.theta = parameter$theta, v.theta = parameter$theta^2,
   alpha.gamma = 3, beta.gamma = parameter$gamma2*2)
start <- parameter
model <- set.to.class("jumpRegression", parameter, prior, start = start,
  fun = fun, sT.fun = sT.fun, Lambda = Lambda)
}

