% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/41_minnesota.R
\name{bv_minnesota}
\alias{bv_minnesota}
\alias{bv_mn}
\alias{bv_lambda}
\alias{bv_alpha}
\alias{bv_psi}
\title{Minnesota prior settings}
\usage{
bv_minnesota(
  lambda = bv_lambda(),
  alpha = bv_alpha(),
  psi = bv_psi(),
  var = 10000000,
  b = 1
)

bv_mn(
  lambda = bv_lambda(),
  alpha = bv_alpha(),
  psi = bv_psi(),
  var = 10000000,
  b = 1
)

bv_lambda(mode = 0.2, sd = 0.4, min = 0.0001, max = 5)

bv_alpha(mode = 2, sd = 0.25, min = 1, max = 3)

bv_psi(scale = 0.004, shape = 0.004, mode = "auto", min = "auto", max = "auto")
}
\arguments{
\item{lambda}{List constructed via \code{\link{bv_lambda}}.
Arguments are \emph{mode}, \emph{sd}, \emph{min} and \emph{max}.
May also be provided as a numeric vector of length 4.}

\item{alpha}{List constructed via \code{\link{bv_alpha}}.
Arguments are \emph{mode}, \emph{sd}, \emph{min} and \emph{max}. High values
for \emph{mode} may affect invertibility of the augmented data matrix.
May also be provided as a numeric vector of length 4.}

\item{psi}{List with elements \emph{scale}, \emph{shape} of the prior
as well as \emph{mode} and optionally \emph{min} and \emph{max}. The length
of these needs to match the number of variables (i.e. columns) in the data.
By default \emph{mode} is set automatically to the square-root of the
innovations variance after fitting an \eqn{AR(p)}{AR(p)} model to the data.
If \code{\link[stats]{arima}} fails due to a non-stationary time series the
order of integration is incremented by 1. By default \emph{min} / \emph{max}
are set to \emph{mode} divided / multiplied by 100.}

\item{var}{Numeric scalar with the prior variance on the model's constant.}

\item{b}{Numeric scalar, vector or matrix with the prior mean. A scalar is
applied to all variables, with a default value of 1. Consider setting it to
0 for growth rates. A vector needs to match the number of variables (i.e.
columns) in the data, with a prior mean per variable. If provided, a matrix
needs to have a column per variable (\eqn{M}), and \eqn{M * p + 1} rows,
where \eqn{p} is the number of lags applied.}

\item{mode, sd}{Numeric scalar. Mode / standard deviation of the
parameter. Note that the \emph{mode} of \emph{psi} is set automatically by
default, and would need to be provided as vector.}

\item{min, max}{Numeric scalar. Minimum / maximum allowed value. Note that
for \emph{psi} these are set automatically or need to provided as vectors.}

\item{scale, shape}{Numeric scalar. Scale and shape parameters of a Gamma
distribution.}
}
\value{
Returns a list of class \code{bv_minnesota} with options for
\code{\link{bvar}}.
}
\description{
Provide settings for the Minnesota prior to \code{\link{bv_priors}}. See the
Details section for further information.
}
\details{
Essentially this prior imposes the hypothesis, that individual variables
all follow random walk processes. This parsimonious specification typically
performs well in forecasts of macroeconomic time series and is often used as
a benchmark for evaluating accuracy (Kilian and Lütkepohl, 2017).
The key parameter is \eqn{\lambda}{lambda} (\emph{lambda}), which controls
the tightness of the prior. The parameter \eqn{\alpha}{alpha} (\emph{alpha})
governs variance decay with increasing lag order, while \eqn{\psi}{psi}
(\emph{psi}) controls the prior's standard deviation on lags of variables
other than the dependent.
The Minnesota prior is often refined with additional priors, trying to
minimise the importance of conditioning on initial observations. See
\code{\link{bv_dummy}} for more information on such priors.
}
\section{Functions}{
\itemize{
\item \code{bv_lambda()}: Tightness of the Minnesota prior

\item \code{bv_alpha()}: Variance decay with increasing lag order

\item \code{bv_psi()}: Prior standard deviation on other lags

}}
\examples{
# Adjust alpha and the Minnesota prior variance.
bv_mn(alpha = bv_alpha(mode = 0.5, sd = 1, min = 1e-12, max = 10), var = 1e6)
# Optionally use a vector as shorthand
bv_mn(alpha = c(0.5, 1, 1e-12, 10), var = 1e6)

# Only adjust lambda's standard deviation
bv_mn(lambda = bv_lambda(sd = 2))

# Provide prior modes for psi (for a VAR with three variables)
bv_mn(psi = bv_psi(mode = c(0.7, 0.3, 0.9)))
}
\references{
Kilian, L. and Lütkepohl, H. (2017). \emph{Structural Vector
  Autoregressive Analysis}. Cambridge University Press,
  \doi{10.1017/9781108164818}
}
\seealso{
\code{\link{bv_priors}}; \code{\link{bv_dummy}}
}
