% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/42_dummy.R, R/43_sur_soc.R
\name{bv_dummy}
\alias{bv_dummy}
\alias{bv_soc}
\alias{bv_sur}
\title{Dummy prior settings}
\usage{
bv_dummy(mode = 1, sd = 1, min = 0.0001, max = 5, fun)

bv_soc(mode = 1, sd = 1, min = 0.0001, max = 50)

bv_sur(mode = 1, sd = 1, min = 0.0001, max = 50)
}
\arguments{
\item{mode}{Numeric scalar. Mode (or the like) of the parameter.}

\item{sd}{Numeric scalar. Standard deviation (or the like) of the parameter.}

\item{min}{Numeric scalar. Minimum allowed value.}

\item{max}{Numeric scalar. Maximum allowed value.}

\item{fun}{Function taking \emph{Y}, \emph{lags} and the prior's parameter
\emph{par} to generate and return a named list with elements \emph{X} and
\emph{Y} (numeric matrices).}
}
\value{
Returns a named list of class \code{bv_dummy} for
\code{\link{bv_priors}}.
}
\description{
Allows the creation of dummy observation priors for \code{\link{bv_priors}}.
}
\examples{
# Create a sum-of-coefficients prior
add_soc <- function(Y, lags, par) {
  soc <- if(lags == 1) {diag(Y[1, ]) / par} else {
    diag(colMeans(Y[1:lags, ])) / par
  }
  Y_soc <- soc
  X_soc <- cbind(rep(0, ncol(Y)), matrix(rep(soc, lags), nrow = ncol(Y)))

  return(list("Y" = Y_soc, "X" = X_soc))
}

soc <- bv_dummy(mode = 1, sd = 1, min = 0.0001, max = 50, fun = add_soc)

# Create a single-unit-root prior
add_sur <- function(Y, lags, par) {
  sur <- if(lags == 1) {Y[1, ] / par} else {
    colMeans(Y[1:lags, ]) / par
  }
  Y_sur <- sur
  X_sur <- c(1 / par, rep(sur, lags))

  return(list("Y" = Y_sur, "X" = X_sur))
}

sur <- bv_dummy(mode = 1, sd = 1, min = 0.0001, max = 50, fun = add_sur)

# Adding them to the prior list with `bv_prior()`
priors_dum <- bv_priors(hyper = "auto", soc = soc, sur = sur)
}
