% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto-ggg-mcmc.R
\name{pggg.mcmc.DrawParameters}
\alias{pggg.mcmc.DrawParameters}
\title{Pareto/GGG Parameter Draws}
\usage{
pggg.mcmc.DrawParameters(cal.cbs, mcmc = 2500, burnin = 500, thin = 50,
  chains = 2, mc.cores = NULL, param_init = NULL, trace = 100)
}
\arguments{
\item{cal.cbs}{Calibration period customer-by-sufficient-statistic (CBS)
data.frame. It must contain a row for each customer, and columns \code{x}
for frequency, \code{t.x} for recency , \code{T.cal} for the total time
observed, as well as the sum over logarithmic intertransaction times
\code{litt}. A correct format can be easily generated based on the complete
event log of a customer cohort with \code{\link{elog2cbs}}.}

\item{mcmc}{Number of MCMC steps.}

\item{burnin}{Number of initial MCMC steps which are discarded.}

\item{thin}{Only every \code{thin}-th MCMC step will be returned.}

\item{chains}{Number of MCMC chains to be run.}

\item{mc.cores}{Number of cores to use in parallel (Unix only). Defaults to \code{min(chains, detectCores())}.}

\item{param_init}{List of start values for cohort-level parameters.}

\item{trace}{Print logging statement every \code{trace}-th iteration. Not available for \code{mc.cores > 1}.}
}
\value{
List of length 2:
\item{\code{level_1}}{list of \code{\link{mcmc.list}}s, one for each customer, with draws for customer-level parameters \code{k}, \code{lambda}, \code{tau}, \code{z}, \code{mu}}
\item{\code{level_2}}{\code{\link{mcmc.list}}, with draws for cohort-level parameters \code{r}, \code{alpha}, \code{s}, \code{beta}, \code{t}, \code{gamma}}
}
\description{
Returns draws from the posterior distributions of the Pareto/GGG
parameters, on cohort as well as on customer level.
}
\details{
See \code{demo('pareto-ggg')} for how to apply this model.
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-12-31")
param.draws <- pggg.mcmc.DrawParameters(cbs,
  mcmc = 20, burnin = 10, thin = 2, chains = 1) # short MCMC to run demo fast

# cohort-level parameter draws
as.matrix(param.draws$level_2)
# customer-level parameter draws for customer with ID '4'
as.matrix(param.draws$level_1[["4"]])

# estimate future transactions
xstar.draws <- mcmc.DrawFutureTransactions(cbs, param.draws, cbs$T.star)
xstar.est <- apply(xstar.draws, 2, mean)
head(xstar.est)
}
\references{
Platzer, Michael, and Thomas Reutterer. 'Ticking Away the Moments: Timing Regularity Helps to Better Predict Customer Activity.' Marketing Science (2016).
}
\seealso{
\code{\link{pggg.GenerateData} } \code{\link{mcmc.PAlive} } \code{\link{mcmc.DrawFutureTransactions} }
}

