% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Poison}
\alias{Poison}
\title{Number of poisonings reported to 16 poison control centers}
\format{
A data frame/tibble with 226,361 observations on one variable
\describe{ 
\item{type}{a factor with levels \code{Alcohol},
\code{Cleaning agent}, \code{Cosmetics}, \code{Drugs}, \code{Insecticides}, and
\code{Plants}} 
}
}
\source{
Centers for Disease Control, Atlanta, Georgia.
}
\usage{
Poison
}
\description{
Data for Exercise 1.113
}
\examples{

T1 <- xtabs(~type, data = Poison)
T1
par(mar = c(5.1 + 2, 4.1, 4.1, 2.1))
barplot(sort(T1, decreasing = TRUE), las = 2, col = rainbow(6))
par(mar = c(5.1, 4.1, 4.1, 2.1))
rm(T1)
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Poison, aes(x = type, fill = type)) + 
           geom_bar() + 
           theme_bw() + 
           theme(axis.text.x  = element_text(angle = 85, vjust = 0.5)) +
           guides(fill = FALSE)
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
