% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Inmate}
\alias{Inmate}
\title{Type of drug offense by race}
\format{
A data frame/tibble with 28,047 observations on two variables
\describe{ 
\item{race}{a factor with levels \code{white},
\code{black}, and \code{hispanic}} 
\item{drug}{a factor with levels \code{heroin}, \code{crack}, \code{cocaine}, 
and \code{marijuana}}
}
}
\source{
C. Wolf Harlow (1994), \emph{Comparing Federal and State Prison Inmates},
NCJ-145864, U.S. Department of Justice, Bureau of Justice Statistics.
}
\usage{
Inmate
}
\description{
Data for Statistical Insight Chapter 8
}
\examples{

T1 <- xtabs(~race + drug, data = Inmate)
T1
chisq.test(T1)
rm(T1)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
