% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condDDP.R
\name{condDDP}
\alias{condDDP}
\title{Conditional dependent Dirichlet process}
\usage{
condDDP(data, group, grid = NULL, niter, nburn, m0 = NULL, k0 = NULL,
  a0 = NULL, b0 = NULL, mass = 1, wei = 0.5, napprox = 10,
  n_approx_unif = 1000, nupd = 1000, out_dens = TRUE,
  print_message = TRUE, light_dens = FALSE)
}
\arguments{
\item{data}{A dataset (vector).}

\item{group}{group for the observed data, same length as data.}

\item{grid}{A grid to evaluate the estimated density (vector).}

\item{niter}{Number of iterations to estimate the model.}

\item{nburn}{Number of burn-in iterations.}

\item{m0}{Mean of the location component of the base measure.}

\item{k0}{Tuning parameter of the variance for the location component of the base measure.}

\item{a0}{Shape parameter of the scale component of the base measure.}

\item{b0}{Rate parameter of the scale component of the base measure.}

\item{mass}{Total mass.}

\item{wei}{weigth of the idiosyncratic process.}

\item{napprox}{Number of values to be sampled from the restricted process via "ICS" method, default 100.}

\item{n_approx_unif}{number of values used in the importance sampling step for the multivariate beta distribution.}

\item{nupd}{How frequently show the curren state of the estimation (number of iterations) - default 1000.}

\item{out_dens}{If TRUE, save the parameters for each iteration, default TRUE.}

\item{print_message}{Print the status of the estimation.}

\item{light_dens}{Return only the posterior mean of the densities.}
}
\value{
A modCond class object contain the estimated density for each iterations,
the allocations for each iterations. If out_param is TRUE, also the parameters.
}
\description{
Conditional dependent Dirichlet process

Estimate an univariate dependent Dirichlet process mixture model with Gaussian kernel using
importance conditional sampler scheme.
}
\examples{
set.seed(42)
data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
group_toy <- c(rep(1,100), rep(2,100))
grid <- seq(-7, 7, length.out = 50)
est_model <- condDDP(data = data_toy, group = group_toy, grid = grid, niter = 1000,
                     nburn = 100, napprox = 100, nupd = 100)
summary(est_model)
plot(est_model)

}
