% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMisc.R
\name{makeBalancedPanel}
\alias{makeBalancedPanel}
\title{Balance a Panel Data Set}
\usage{
makeBalancedPanel(data, idname, tname, return_data.table = FALSE)
}
\arguments{
\item{data}{data.frame used in function}

\item{idname}{unique id}

\item{tname}{time period name}

\item{return_data.table}{if TRUE, makeBalancedPanel will
return a data.table rather than a data.frame.  Default
is FALSE.}
}
\value{
data.frame that is a balanced panel
}
\description{
This function drops observations from data.frame
 that are not part of balanced panel data set.
}
\examples{
id <- rep(seq(1, 100), each = 2) # individual ids for setting up a two period panel
t <- rep(seq(1, 2), 100) # time periods
y <- rnorm(200) # outcomes
dta <- data.frame(id = id, t = t, y = y) # make into data frame
dta <- dta[-7, ] # drop the 7th row from the dataset (which creates an unbalanced panel)
dta <- makeBalancedPanel(dta, idname = "id", tname = "t")

}
