% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpsedist.R
\name{mpsedist}
\alias{mpsedist}
\title{Maximum Product of Spacing Fit of Univariate Distributions.}
\source{
Based on the function mledist of the R package: fitdistrplus
  
  Delignette-Muller ML and Dutang C (2015), \emph{fitdistrplus: An R Package 
  for Fitting Distributions}. Journal of Statistical Software, 64(4), 1-34.
  
  Functions \code{checkparam} and \code{start.arg.default} are needed and 
  were copied from the same package (fitdistrplus version: 1.0-9).
}
\usage{
mpsedist(data, distr, start = NULL, fix.arg = NULL,
  optim.method = "default", lower = -Inf, upper = Inf,
  custom.optim = NULL, weights = NULL, silent = TRUE, gradient = NULL,
  ...)
}
\arguments{
\item{data}{A numeric vector with the observed values for non-censored data.}

\item{distr}{A character string \code{"name"} naming a distribution for which
the corresponding density function \code{dname} and the corresponding 
distribution function \code{pname} must be classically defined.}

\item{start}{A named list giving the initial values of parameters of the 
named distribution or a function of data computing initial values and 
returning a named list. This argument may be omitted (default) for some 
distributions for which reasonable starting values are computed (see the 
'details' section of \code{\link{mledist}}).}

\item{fix.arg}{An optional named list giving the values of fixed parameters 
of the named distribution or a function of data computing (fixed) parameter
values and returning a named list. Parameters with fixed value are thus NOT
estimated.}

\item{optim.method}{\code{"default"} (see details) or an optimization method 
to pass to \code{\link{optim}}.}

\item{lower}{Left bounds on the parameters for the \code{"L-BFGS-B"} method 
(see \code{\link{optim}}) or the \code{\link{constrOptim}} function (as an 
equivalent linear constraint).}

\item{upper}{Right bounds on the parameters for the \code{"L-BFGS-B"} method 
(see \code{\link{optim}}) or the \code{\link{constrOptim}} function (as an 
equivalent linear constraint).}

\item{custom.optim}{A function carrying the optimization (see details).}

\item{weights}{An optional vector of weights to be used in the fitting 
process. Should be \code{NULL} or a numeric vector with strictly positive 
numbers. If non-\code{NULL}, weighted mpse is used, otherwise ordinary 
mpse.}

\item{silent}{A logical to remove or show warnings when bootstraping.}

\item{gradient}{A function to return the gradient of the optimization
objective function for the \code{"BFGS"}, \code{"CG"} and \code{"L-BFGS-B"}
methods. If it is \code{NULL}, a finite-difference approximation will be
used, see \code{\link{optim}}.}

\item{\dots}{Further arguments passed to the \code{\link{optim}}, 
\code{\link{constrOptim}} or \code{custom.optim} function.}
}
\value{
\code{mpsedist} returns a list with following components,
  
  \item{estimate}{ the parameter estimates.}
  
  \item{convergence}{ an integer code for the convergence of 
  \code{\link{optim}} defined as below or defined by the user in the 
  user-supplied optimization function.
  
  \code{0} indicates successful convergence.
  
  \code{1} indicates that the iteration limit of \code{\link{optim}} has been
  reached.
  
  \code{10} indicates degeneracy of the Nealder-Mead simplex.
  
  \code{100} indicates that \code{\link{optim}} encountered an internal 
  error. }
  
  \item{value}{ the value of the optimization objective function at the solution found. }
  
  \item{loglik}{ the log-likelihood. }
  
  \item{hessian}{ a symmetric matrix computed by \code{\link{optim}} as an
  estimate of the Hessian at the solution found or computed in the
  user-supplied optimization function. }
  
  \item{optim.function }{ the name of the optimization function used.  }
  
  \item{fix.arg}{ the named list giving the values of parameters of the named
  distribution that must kept fixed rather than estimated by maximum
  likelihood or \code{NULL} if there are no such parameters. }
  
  \item{optim.method}{when \code{\link{optim}} is used, the name of the
  algorithm used, \code{NULL} otherwise.}
  
  \item{fix.arg.fun}{the function used to set the value of \code{fix.arg} or
  \code{NULL}.}
  
  \item{weights}{the vector of weigths used in the estimation process or 
  \code{NULL}.}
  
  \item{counts}{A two-element integer vector giving the number of calls to
  the log-likelihood function and its gradient respectively. This excludes
  those calls needed to compute the Hessian, if requested, and any calls to
  log-likelihood function to compute a finite-difference approximation to the
  gradient. \code{counts} is returned by \code{\link{optim}} or the
  user-supplied optimization function, or set to \code{NULL}.}
  
  \item{optim.message}{A character string giving any additional information 
  returned by the optimizer, or \code{NULL}. To understand exactly the 
  message, see the source code.}
}
\description{
Fit of univariate distributions for non-censored data using 
  maximum product of spacing estimation (mpse), also called maximum spacing 
  estimation.
}
\details{
The \code{mpsedist} function carries out the maximum product of 
  spacing estimation numerically, by maximization of the arithmetic mean of
  \eqn{\log(F(k) - F(k-1))}.
  
  The optimization process is the same as 
  \code{\link{mledist}}, see the 'details' section of that 
  function.
  
  Optionally, a vector of \code{weights} can be used in the fitting process. 
  By default (when \code{weigths=NULL}), ordinary mpse is carried out, 
  otherwise the specified weights are used to compute a weighted arithmetic
  mean.
  
  We believe this function should be added to the package 
  \code{\link{fitdistrplus}}. Until it is accepted and incorporated into that
  package, it will remain in the package \code{\link{BMT}}. This function is 
  internally called in \code{\link{BMTfit.mpse}}.
}
\examples{
# (1) basic fit of a normal distribution 
set.seed(1234)
x1 <- rnorm(n = 100)
mean(x1); sd(x1)
mpse1 <- mpsedist(x1, "norm")
mpse1$estimate

# (2) defining your own distribution functions, here for the Gumbel 
# distribution for other distributions, see the CRAN task view dedicated 
# to probability distributions
dgumbel <- function(x, a, b) 1/b*exp((a-x)/b)*exp(-exp((a-x)/b))
pgumbel <- function(q, a, b) exp(-exp((a-q)/b))
qgumbel <- function(p, a, b) a-b*log(-log(p))
mpse1 <- mpsedist(x1, "gumbel", start = list(a = 10, b = 5))
mpse1$estimate

# (3) fit a discrete distribution (Poisson)
set.seed(1234)
x2 <- rpois(n = 30, lambda = 2)
mpse2 <- mpsedist(x2, "pois")
mpse2$estimate

# (4) fit a finite-support distribution (beta)
set.seed(1234)
x3 <- rbeta(n = 100, shape1 = 5, shape2 = 10)
mpse3 <- mpsedist(x3, "beta")
mpse3$estimate

# (5) fit frequency distributions on USArrests dataset.
x4 <- USArrests$Assault
mpse4pois <- mpsedist(x4, "pois")
mpse4pois$estimate
mpse4nbinom <- mpsedist(x4, "nbinom")
mpse4nbinom$estimate

# (6) weighted fit of a normal distribution 
set.seed(1234)
w1 <- runif(101)
mpse1 <- mpsedist(x1, "norm", weights = w1)
mpse1$estimate

}
\references{
Cheng, R. and N. Amin (1983). \emph{Estimating parameters in 
  continuous univariate distributions with a shifted origin}. Journal of the 
  Royal Statistical Society. Series B (Methodological), 394-403.
  
  Ranneby, B. (1984). \emph{The maximum spacing method. an estimation method 
  related to the maximum likelihood method}. Scandinavian Journal of 
  Statistics, 93-112.
}
\seealso{
\code{\link{mqdedist}}, \code{\link{mledist}}, 
  \code{\link{mmedist}}, \code{\link{qmedist}}, 
  \code{\link{mgedist}}, and \code{\link{optim}}.
}
\author{
Camilo Jose Torres-Jimenez [aut,cre] \email{cjtorresj@unal.edu.co}
}
\keyword{distribution}
