% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.BMEmapping.R
\name{summary.BMEmapping}
\alias{summary.BMEmapping}
\title{Summary Method for BME Cross-Validation Results}
\usage{
\method{summary}{BMEmapping}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"bme_cv"}, typically returned by a
BME cross-validation function. Must contain a numeric vector named
\code{residual}.}

\item{...}{Additional arguments passed to \code{summary()}.}
}
\value{
A data frame containing three columns:
\describe{
\item{\code{ME}}{Mean Error (average residual).}
\item{\code{MAE}}{Mean Absolute Error.}
\item{\code{RMSE}}{Root Mean Squared Error.}
}
}
\description{
Provides a concise summary of LOOCV performance for BME predictions at hard
data locations. Computes standard residual-based accuracy metrics, including
Mean Error (ME), Mean Absolute Error (MAE), and Root Mean Squared Error (RMSE).
}
