% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIS.R
\name{get_bis}
\alias{get_bis}
\title{Download and parse a BIS data set}
\usage{
get_bis(url, auto_pivot = TRUE, ...)
}
\arguments{
\item{url}{Character. URL of the data set to be imported (usually obtained
through \code{get_datasets()}).}

\item{auto_pivot}{Logical. Controls whether source data set is converted to
long format. Set this to \code{FALSE} to disable conversion (default: TRUE).}

\item{...}{Arguments passed to \code{download.file()} (e.g.
\code{quiet = TRUE}).}
}
\value{
A tibble data frame, or a list of tibble data frames in cases where
the source zip file contains multiple csv files.
}
\description{
Download and parse a BIS data set
}
\details{
Large data sets may cause \code{get_bis()} to fail if the amount of
available memory is insufficient for executing a required pivot operation. As
a workaround, users may wish to set \code{auto_pivot = FALSE} when calling
\code{get_bis()}, then subset the data and run \code{pivot_longer_bis()}
manually. See the vignette for detail.
}
\examples{
\donttest{
ds <- get_datasets()
df <- get_bis(ds$url[2])
}
}
